/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.pattern;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import org.conqat.engine.sourcecode.pattern.EnumPattern;
import org.conqat.lib.commons.collections.IntList;

public class EnumPatternMatcher
implements MatchResult {
    private final Matcher matcher;
    private final IntList positions;

    EnumPatternMatcher(EnumPattern pattern, String string, IntList positions) {
        this.positions = positions;
        this.matcher = pattern.getPattern().matcher(string);
    }

    private int getPosition(int stringPosition) {
        if (this.isIdentityMapping()) {
            return stringPosition;
        }
        int n = this.positions.getSize();
        for (int i = 0; i < n; ++i) {
            Integer position = this.positions.get(i);
            if (stringPosition > position) continue;
            return i;
        }
        return -1;
    }

    private boolean isIdentityMapping() {
        return this.positions == null;
    }

    public boolean find() {
        return this.matcher.find();
    }

    public boolean matches() {
        return this.matcher.matches();
    }

    public boolean lookingAt() {
        return this.matcher.lookingAt();
    }

    @Override
    public int end() {
        int end = this.matcher.end();
        return this.getPosition(end);
    }

    @Override
    public int end(int group) {
        return this.getPosition(this.matcher.end(group));
    }

    @Override
    public String group() {
        return this.matcher.group();
    }

    @Override
    public String group(int group) {
        return this.matcher.group(group);
    }

    @Override
    public int groupCount() {
        return this.matcher.groupCount();
    }

    @Override
    public int start() {
        int start = this.matcher.start();
        return this.getPosition(start);
    }

    @Override
    public int start(int group) {
        return this.getPosition(this.matcher.start(group));
    }
}

