/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.abap;

import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.repository.sap.abapsystem.GlobalSapSystemConnectionOption;
import com.teamscale.index.repository.sap.abapsystem.snc.SncCredentialsManager;
import com.teamscale.index.repository.sap.abapsystem.snc.SncException;
import com.teamscale.index.repository.sap.abapsystem.snc.SncUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.Optional;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/abap-snc-credentials")
public class SncCredentialsService
extends ApiBase {
    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Creates SNC credentials", description="Backups existing credentials and creates a new one from available PSE files.", tags={"Administration"})
    public String createCredentials() throws SncException, StorageException {
        String serviceLibrary = this.getValidatedSapCryptoSncServiceLibrary();
        SncCredentialsManager sncCredentialsManager = SncCredentialsManager.getInstance((String)serviceLibrary);
        sncCredentialsManager.validatePseFiles();
        return sncCredentialsManager.createCredentials();
    }

    @PUT
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Registers a single PSE file into cred_v2", description="Registers a PSE file into cred_v2", tags={"Administration"})
    @Path(value="{pseFile}")
    public String addPseFileIntoCredentials(@Parameter(description="Name of the PSE file") @PathParam(value="pseFile") String pseFile) throws SncException, StorageException {
        String serviceLibrary = this.getValidatedSapCryptoSncServiceLibrary();
        SncCredentialsManager sncCredentialsManager = SncCredentialsManager.getInstance((String)serviceLibrary);
        return sncCredentialsManager.addPseIntoCredentials(pseFile);
    }

    @DELETE
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Unregisters a single PSE file from cred_v2", description="unregisters a PSE file from cred_v2", tags={"Administration"})
    @Path(value="{pseFile}")
    public String removePseFileFromCredentials(@Parameter(description="Name of the PSE file") @PathParam(value="pseFile") String pseFile) throws SncException, StorageException {
        String serviceLibrary = this.getValidatedSapCryptoSncServiceLibrary();
        SncCredentialsManager sncCredentialsManager = SncCredentialsManager.getInstance((String)serviceLibrary);
        return sncCredentialsManager.removePseFromCredentials(pseFile);
    }

    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Returns all PSEs in a credentials file.", description="Reads credentials and returns details of all PSEs.", tags={"Administration"})
    public String viewCredentials() throws SncException, StorageException {
        String serviceLibrary = this.getValidatedSapCryptoSncServiceLibrary();
        SncCredentialsManager sncCredentialsManager = SncCredentialsManager.getInstance((String)serviceLibrary);
        return sncCredentialsManager.viewCredentials();
    }

    private String getValidatedSapCryptoSncServiceLibrary() throws SncException, StorageException {
        String serviceLibrary = SncUtils.getSncServiceLibraryFromEnvVar();
        if (StringUtils.isEmpty((String)serviceLibrary)) {
            ServerOptionIndex optionIndex = this.openGlobalIndex(ServerOptionIndex.class);
            GlobalSapSystemConnectionOption globalSapOption = (GlobalSapSystemConnectionOption)ServerOptionRegistry.getInstance().getServerOption("sap.abap.global", GlobalSapSystemConnectionOption.class, optionIndex);
            serviceLibrary = globalSapOption.jcoSncLibrary;
        }
        if (SncUtils.isSapCryptoSncOsLibrary((String)serviceLibrary)) {
            Optional optValidation = SncUtils.validateServiceLibrary((String)serviceLibrary);
            if (optValidation.isPresent()) {
                throw new SncException((String)optValidation.get());
            }
            return serviceLibrary;
        }
        throw new SncException("A valid SNC SAPCrypto service library is needed for managing PSE credentials and none was found. Please provide it preferably in the `SNC_LIB` environment variable otherwise in the SAP ABAP System Connection - Global Settings. Provided library path: " + serviceLibrary);
    }
}

