/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.accessibility;

import com.teamscale.commons.TeamscaleInstallationUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.jetbrains.annotations.VisibleForTesting;

@Path(value="api/accessibility")
public class DeclarationOfAccessibilityService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String DECLARATION_OF_ACCESSIBILITY_FILE_NAME = "declaration_of_accessibility.md";
    private static final DeclarationHolder DECLARATION_HOLDER = new DeclarationHolder();

    @Operation(summary="Get the declaration of accessibility", description="Returns the declaration of accessibility as found in the configuration directory (file name: 'declaration_of_accessibility.md'). To avoid unnecessary IO lookups, the declaration (or non-existent declaration) is locally cached until a reload is forced.", tags={"Miscellaneous"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Contains the configured declaration of accessibility", content={@Content(schema=@Schema(type="string"))}), @ApiResponse(responseCode="204", description="No declaration of accessibility is present")})
    @GET
    @Path(value="declaration")
    @RequiresNoLogin
    @Produces(value={"text/markdown"})
    public @Nullable String getDeclarationOfAccessibility(@QueryParam(value="force-reload") @Parameter(description="Whether a reload should be forced.") boolean forceReload) {
        return DECLARATION_HOLDER.getDeclarationOfAccessibility(forceReload).orElse(null);
    }

    @VisibleForTesting
    static void setCachedDeclarationValue(String value) {
        DECLARATION_HOLDER.setLoadedValue(value);
    }

    private static class DeclarationHolder {
        private Optional<String> loadedValue = DeclarationHolder.loadDeclarationOfAccessibility();

        private DeclarationHolder() {
        }

        public Optional<String> getDeclarationOfAccessibility(boolean forceReload) {
            if (forceReload) {
                this.loadedValue = DeclarationHolder.loadDeclarationOfAccessibility();
            }
            return this.loadedValue;
        }

        @VisibleForTesting
        void setLoadedValue(String loadedValue) {
            this.loadedValue = Optional.ofNullable(loadedValue);
        }

        private static Optional<String> loadDeclarationOfAccessibility() {
            Optional file = TeamscaleInstallationUtils.locateConfigFile((String)DeclarationOfAccessibilityService.DECLARATION_OF_ACCESSIBILITY_FILE_NAME);
            if (file.isPresent()) {
                try {
                    return Optional.of(FileSystemUtils.readFileUTF8((File)((File)file.get())));
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to read declaration of accessibility", (Throwable)e);
                    return Optional.empty();
                }
            }
            return Optional.empty();
        }
    }
}

