/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit.benchmark;

import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.MetricDirectoryIndex;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.PermissionLookup;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.service.audit.benchmark.ProjectBenchmarkDownloadService;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectIdBase;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class MetricBenchmarkComputation {
    private static final int NUM_CHARACTERS = 26;
    private final ITeamscaleServiceInfo serviceInfo;
    private final PermissionLookup<EProjectPermission> permissionLookup;

    public MetricBenchmarkComputation(ITeamscaleServiceInfo storageInfo, PermissionLookup<EProjectPermission> permissionLookup) {
        this.serviceInfo = storageInfo;
        this.permissionLookup = permissionLookup;
    }

    public List<ProjectBenchmarkDownloadService.BenchmarkResult> getBenchmarkResults(String metricName, List<PublicProjectId> nonAnonymizedProjectIds, List<PublicProjectId> anonymizedProjectIds) throws StorageException {
        ProjectIndex projectIndex = (ProjectIndex)this.serviceInfo.getGlobalStorageSystem().openGlobalIndex(ProjectIndex.class);
        ArrayList<ProjectBenchmarkDownloadService.BenchmarkResult> benchmarkResults = new ArrayList<ProjectBenchmarkDownloadService.BenchmarkResult>();
        benchmarkResults.addAll(this.getBenchmarkResults(metricName, nonAnonymizedProjectIds, projectIndex, false));
        benchmarkResults.addAll(this.getBenchmarkResults(metricName, anonymizedProjectIds, projectIndex, true));
        return benchmarkResults;
    }

    private List<ProjectBenchmarkDownloadService.BenchmarkResult> getBenchmarkResults(String metricName, List<PublicProjectId> projectIds, ProjectIndex projectIndex, boolean anonymize) throws StorageException {
        ArrayList<ProjectBenchmarkDownloadService.BenchmarkResult> benchmarkResults = new ArrayList<ProjectBenchmarkDownloadService.BenchmarkResult>();
        for (PublicProjectId projectId : projectIds) {
            ProjectInfo projectInfo = projectIndex.resolveProject((IProjectId)projectId);
            if (!this.isPermissionCheckSuccessful(projectInfo)) continue;
            String projectName = projectInfo.getName();
            if (anonymize) {
                projectName = MetricBenchmarkComputation.getAnonymizedProjectName(projectInfo.getInternalId(), projectIndex);
            }
            this.getBenchmarkResultsFor(projectInfo, metricName, projectName).ifPresent(benchmarkResults::add);
        }
        return benchmarkResults;
    }

    private boolean isPermissionCheckSuccessful(ProjectInfo projectInfo) {
        return this.permissionLookup.getPermissions(CollectionUtils.map((Collection)projectInfo.getPublicIds(), ProjectIdBase::toString)).contains(EProjectPermission.VIEW);
    }

    private static String getAnonymizedProjectName(InternalProjectId projectId, ProjectIndex projectIndex) throws StorageException {
        int index = projectIndex.getAllInternalProjectIds().indexOf(projectId);
        return MetricBenchmarkComputation.getAnonymizedProjectName(index);
    }

    protected static String getAnonymizedProjectName(int indexOfProject) {
        int n = indexOfProject % 26;
        int m = indexOfProject / 26;
        return Character.toString((char)(65 + n)) + m;
    }

    private Optional<ProjectBenchmarkDownloadService.BenchmarkResult> getBenchmarkResultsFor(ProjectInfo projectInfo, String metricName, String projectNameToUse) throws StorageException {
        MetaIndex projectMetaIndex;
        HistoryAccessOption historyAccess;
        CommitResolvingStorageSystem projectStorage = this.serviceInfo.getProjectStorageSystem(projectInfo);
        Optional<Object> metricValue = MetricBenchmarkComputation.getMetricValue(metricName, (ProjectStorageSystem)projectStorage, historyAccess = HistoryAccessOption.readHead((String)(projectMetaIndex = (MetaIndex)projectStorage.openProjectIndex(MetaIndex.class, null)).getDefaultBranchName()));
        if (metricValue.isEmpty()) {
            return Optional.empty();
        }
        ELanguage language = this.getLanguageOfProject(projectInfo);
        long timestamp = MetricBenchmarkComputation.getTimeStampOfProject((ProjectStorageSystem)projectStorage, historyAccess);
        ProjectBenchmarkDownloadService.BenchmarkResult result = new ProjectBenchmarkDownloadService.BenchmarkResult(new PublicProjectId(projectNameToUse), UniformPath.codeRoot(), timestamp, ETeamscaleVersion.CURRENT_VERSION, language);
        result.addMetricValue(metricName, metricValue.get());
        return Optional.of(result);
    }

    private static Optional<Object> getMetricValue(String metricName, ProjectStorageSystem projectStorage, HistoryAccessOption historyAccess) throws StorageException {
        MetricDirectoryIndex metricDirectoryIndex = (MetricDirectoryIndex)projectStorage.openProjectIndex(MetricDirectoryIndex.class, "metrics-dir", historyAccess);
        MetricDirectoryEntry metrics = metricDirectoryIndex.getMetricDirectoryEntry("");
        if (metrics == null) {
            return Optional.empty();
        }
        MetricSchemaIndex metricSchemaIndex = (MetricSchemaIndex)projectStorage.openProjectIndex(MetricSchemaIndex.class, "metric-schema", historyAccess.cloneToUnbranchedAccessOption());
        MetricDirectorySchema schema = metricSchemaIndex.getPublicSchema();
        int valuePosition = schema.getValuePosition(metricName);
        if (valuePosition == -1) {
            return Optional.empty();
        }
        return Optional.of(metrics.getValue(valuePosition));
    }

    private ELanguage getLanguageOfProject(ProjectInfo projectInfo) throws StorageException {
        AnalysisProfile analysisProfile = AnalysisProfileUtils.getEmbeddedAnalysisProfile((IndexLayer)this.serviceInfo.getIndexLayer(), (PublicProjectId)projectInfo.getPrimaryPublicId(), (CodeScopeName)CodeScopeAware.DEFAULT_CODE_SCOPE);
        return (ELanguage)CollectionUtils.getAny((Iterable)analysisProfile.getLanguages());
    }

    private static long getTimeStampOfProject(ProjectStorageSystem projectStorage, HistoryAccessOption historyAccess) throws StorageException {
        long timestamp = historyAccess.getTimestamp();
        if (historyAccess.isReadHead()) {
            RepositoryLogIndex logIndex = (RepositoryLogIndex)projectStorage.openProjectIndex(RepositoryLogIndex.class, null);
            timestamp = logIndex.getNewestTimestamp();
        }
        return timestamp;
    }
}

