/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit.xclones;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.index.audit.analysis.xclones.ExternalXCloneClass;
import com.teamscale.index.audit.analysis.xclones.ExternalXCloneIndex;
import com.teamscale.index.audit.analysis.xclones.ExternalXCloneStatus;
import com.teamscale.index.audit.analysis.xclones.ExternalXCloneTrigger;
import com.teamscale.index.audit.analysis.xclones.ExternalXClonesParameter;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.EComplexPermission;
import com.teamscale.service.framework.authorization.RequiresComplexPermission;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/audit/external-x-clones")
public class ExternalXCloneService
extends ApiBase {
    @GET
    @Operation(summary="Get external clone classes", description="Retrieves the found external clone classes", tags={"Audit"})
    @RequiresComplexPermission(value=EComplexPermission.MAY_ACCESS_AUDIT_PERSPECTIVE)
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Path(value="classes")
    public List<ExternalXCloneClass> getAllExternalCrossClones() throws StorageException {
        return this.openProjectIndex(ExternalXCloneIndex.class, null).getAllCloneClasses();
    }

    @GET
    @Path(value="status")
    @Operation(summary="Get external clone detection status", description="Retrieves the current status of running external clone detection.", tags={"Audit"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @RequiresComplexPermission(value=EComplexPermission.MAY_ACCESS_AUDIT_PERSPECTIVE)
    public ExternalXCloneStatus getStatusOfCloneDetection() throws StorageException {
        return this.openProjectIndex(ExternalXCloneIndex.class, null).getStatus();
    }

    @POST
    @Operation(summary="Schedule external clone detection", description="Schedules the trigger for external clone detection", tags={"Audit"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @RequiresComplexPermission(value=EComplexPermission.MAY_ACCESS_AUDIT_PERSPECTIVE)
    public void scheduleCloneDetectionTrigger(@RequestBody(required=true) ExternalXClonesParameter parameter) throws StorageException {
        JobDescriptor job = new JobDescriptor(this.serviceInfo.getInternalId(), ExternalXCloneTrigger.class, null, (Object)parameter, "Scheduled by " + this.getClass().getSimpleName());
        ISchedulerCommunicator.getInstance().scheduleExternalJob(this.getIndexLayer(), job);
        this.openProjectIndex(ExternalXCloneIndex.class, null).updateStatus(new ExternalXCloneStatus("Waiting for trigger to be scheduled..."));
    }
}

