/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.tracking.FindingChurnCount;
import com.teamscale.index.tracking.index.FindingChurnCountIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/finding-churn/count")
public class FindingChurnCountService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(description="This service provides access to the finding churn count.")
    public List<FindingChurnCount> getFindingChurnCount(@QueryParam(value="commit") List<UnresolvedCommitDescriptor> commits) throws StorageException {
        List<CommitDescriptor> commitDescriptors = this.resolveCommits(commits);
        return this.openProjectIndex(FindingChurnCountIndex.class, null).getEntries(commitDescriptors);
    }
}

