/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.conqat.engine.index.baseline.BaselineInfo;
import org.conqat.engine.persistence.store.StorageException;

public interface IBaselineServiceApi {
    @GET
    @PublicApi(since=ETeamscaleVersion.VERSION_5_2_0)
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get all baselines", description="Returns a list of all configured baselines for the project.", tags={"Baselines"})
    public List<BaselineInfo> getAllBaselines() throws StorageException;

    @GET
    @Path(value="{baseline}")
    @PublicApi(since=ETeamscaleVersion.VERSION_5_2_0)
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get baseline", description="Returns details on a configured baseline.", tags={"Baselines"})
    public BaselineInfo getBaseline(@PathParam(value="baseline") String var1) throws StorageException;

    @PUT
    @Path(value="{baseline}")
    @PublicApi(since=ETeamscaleVersion.VERSION_5_2_0)
    @RequiresProjectPermission(value={EProjectPermission.EDIT_BASELINES})
    @Operation(summary="Update baseline", description="Creates a new or updates an existing baseline.", tags={"Baselines"})
    public void createOrUpdateBaseline(@PathParam(value="baseline") String var1, @Parameter(description="Old baseline name, needed if case of baseline renaming") @QueryParam(value="old-name") String var2, @RequestBody(required=true) BaselineInfo var3) throws StorageException;

    @DELETE
    @Path(value="{baseline}")
    @PublicApi(since=ETeamscaleVersion.VERSION_5_2_0)
    @Operation(summary="Delete baseline", description="Deletes a baseline.", tags={"Baselines"})
    @RequiresProjectPermission(value={EProjectPermission.EDIT_BASELINES})
    public void deleteBaseline(@PathParam(value="baseline") String var1) throws StorageException;
}

