/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues;

import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;

@Path(value="api/relative-date-resolution")
public class RelativeDateResolutionService
extends ApiBase {
    @GET
    @RequiresNoPermission
    @Operation(summary="Get Absolute Date", description="Transforms a relative date string into a fixed date string", tags={"Connectors"}, responses={@ApiResponse(responseCode="400", description="Invalid relative date provided.")})
    public String getAbsoluteDate(@QueryParam(value="relativeDate") String relativeDate) throws IllegalArgumentException {
        String parsedAbsoluteDate = ConnectorUtils.replaceRelativeDate((String)relativeDate);
        if (parsedAbsoluteDate.equals(relativeDate)) {
            throw new IllegalArgumentException("Provided relative timestamp is invalid.");
        }
        return parsedAbsoluteDate;
    }
}

