/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.merge_request.MergeBaseCacheIndex;
import com.teamscale.index.repository.CommitResolutionException;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.repository.MergeBaseResolver;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/merge-requests/parent-info")
public class MergeRequestParentInfoService
extends ApiBase {
    @GET
    @Operation(summary="Get merge request parent info", description="Retrieves information on the parent commits for a merge request (merge-base, source-only ancestors).", tags={"Merge Requests"}, responses={@ApiResponse(responseCode="400", description="Invalid parameters provided."), @ApiResponse(responseCode="404", description="Could not find common ancestor commit for the source and target commits.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public MergeRequestParentInfoTransport getMergeRequestParentInfo(@Parameter(description="The source commit descriptor.", required=true) @QueryParam(value="source") UnresolvedCommitDescriptor unresolvedSourceCommit, @Parameter(description="The target commit descriptor.", required=true) @QueryParam(value="target") UnresolvedCommitDescriptor unresolvedTargetCommit, @Parameter(description="Whether only the merge-base field in the result object should be filled.") @QueryParam(value="merge-base-only") boolean mergeBaseOnly) throws StorageException {
        CommitDescriptor sourceCommit = this.resolve(unresolvedSourceCommit);
        CommitDescriptor targetCommit = this.resolve(unresolvedTargetCommit);
        try {
            MergeRequestParentInfoTransport transportObject;
            Optional mergeParentInfo = MergeBaseResolver.computeMergeBaseInfo((CommitDescriptor)sourceCommit, (CommitDescriptor)targetCommit, (CommitDescriptorIndex)this.openCommitDescriptorIndex());
            if (mergeBaseOnly && mergeParentInfo.isPresent()) {
                String storageKey = this.openProjectIndex(MergeBaseCacheIndex.class, null).insertMergeParentInfoFor((MergeBaseInfo)mergeParentInfo.get(), sourceCommit, targetCommit);
                transportObject = new MergeRequestParentInfoTransport(((MergeBaseInfo)mergeParentInfo.get()).getMergeBase(), null, storageKey);
            } else if (mergeParentInfo.isPresent()) {
                String storageKey = this.openProjectIndex(MergeBaseCacheIndex.class, null).insertMergeParentInfoFor((MergeBaseInfo)mergeParentInfo.get(), sourceCommit, targetCommit);
                transportObject = new MergeRequestParentInfoTransport(((MergeBaseInfo)mergeParentInfo.get()).getMergeBase(), (MergeBaseInfo)mergeParentInfo.get(), storageKey);
            } else {
                throw new NotFoundException("Could not find a common ancestor commit for " + String.valueOf(sourceCommit) + " and " + String.valueOf(targetCommit) + ". Maybe the analyzed history is too short?");
            }
            return transportObject;
        }
        catch (CommitResolutionException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    public static class MergeRequestParentInfoTransport {
        @JsonProperty(value="mergeBase")
        public CommitDescriptor mergeBase;
        @JsonProperty(value="fullMergeParentInfo")
        public @Nullable MergeBaseInfo fullMergeParentInfo;
        @JsonProperty(value="cacheStorageKey")
        public @Nullable String cacheStorageKey;

        private MergeRequestParentInfoTransport(CommitDescriptor mergeBase, @Nullable MergeBaseInfo fullMergeParentInfo, @Nullable String cacheStorageKey) {
            this.mergeBase = mergeBase;
            this.fullMergeParentInfo = fullMergeParentInfo;
            this.cacheStorageKey = cacheStorageKey;
        }
    }
}

