/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.index.repository.git.common.GitRepositoryManagementConnectorDescriptorBase;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/projects/{project}/merge-requests/rerun-synchronizers")
public class MergeRequestSynchronizerForceRunService
extends ApiBase {
    @POST
    @Operation(summary="Schedules all merge request synchronizers.", description="Schedules the merge request synchronizers for all voting connectors in the given project.This can be used to manually update all merge requests in Teamscale.", responses={@ApiResponse(responseCode="400", description="No voting connector is configured for the project"), @ApiResponse(responseCode="502", description="Retrieving open merge requests failed")}, tags={"Debugging", "Merge Requests", "Voting Connectors"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void runMergeRequestSynchronizerForProject() throws Exception {
        List<GitRepositoryManagementConnectorDescriptorBase> votingConnectorDescriptors = this.getAllProjectVotingConnectorDescriptors();
        if (votingConnectorDescriptors.isEmpty()) {
            throw new BadRequestException("No voting connectors configured for project \"%s\"".formatted(this.serviceInfo.getPrimaryPublicId()));
        }
        for (GitRepositoryManagementConnectorDescriptorBase connectorDescriptor : votingConnectorDescriptors) {
            this.scheduleMergeRequestSynchronizerForConnector(connectorDescriptor);
        }
    }

    @POST
    @Path(value="{repositoryId}")
    @Operation(summary="Schedules the merge request synchronizer for the given repository.", description="Schedules the merge request synchronizer for the voting connector with the repository identifier `repositoryId` in the given project.This can be used to manually update all merge requests for the connector in Teamscale.", responses={@ApiResponse(responseCode="400", description="No voting connector is configured for the project"), @ApiResponse(responseCode="502", description="Retrieving open merge requests failed")}, tags={"Debugging", "Merge Requests", "Voting Connectors"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void runMergeRequestSynchronizerForRepository(@PathParam(value="repositoryId") String repositoryId) throws StorageException, ProjectConfigurationException {
        Optional<GitRepositoryManagementConnectorDescriptorBase> votingConnector = this.getProjectVotingConnector(repositoryId);
        if (votingConnector.isEmpty()) {
            throw new BadRequestException("Connector with repository identifier \"" + repositoryId + "\" does not exist or is not a voting connector.");
        }
        this.scheduleMergeRequestSynchronizerForConnector(votingConnector.get());
    }

    private void scheduleMergeRequestSynchronizerForConnector(GitRepositoryManagementConnectorDescriptorBase connectorDescriptor) throws StorageException {
        String triggerName = new TriggerBuilder(connectorDescriptor.getPullRequestSynchronizerClass()).buildTriggerName(connectorDescriptor.getConnectorIdentifier());
        MergeRequestIndex mergeRequestIndex = this.openProjectIndex(MergeRequestIndex.class, null);
        String repositoryName = connectorDescriptor.getOptionByName("Repository name").retrieveValueAsString(null);
        mergeRequestIndex.setLastMergeRequestPollTimestamp(repositoryName, Instant.EPOCH);
        ISchedulerCommunicator.getInstance().scheduleExternallyStartedTrigger(this.getIndexLayer(), this.serviceInfo.getInternalId(), triggerName);
    }

    private Optional<GitRepositoryManagementConnectorDescriptorBase> getVotingConnectorDescriptor(ConnectorConfiguration connector) throws ProjectConfigurationException, StorageException {
        ConnectorDescriptorBase connectorDescriptor = ConnectorUtils.loadConnector((ConnectorConfiguration)connector, (ConfigurationInitializationContext)new ConfigurationInitializationContext(this.getIndexLayer(), (IExternalCredentialsProvider)this.getGlobalStorageSystem().openGlobalIndex(ExternalCredentialsIndex.class)), (InternalProjectId)this.serviceInfo.getInternalId());
        if (connectorDescriptor instanceof GitRepositoryManagementConnectorDescriptorBase) {
            return Optional.of((GitRepositoryManagementConnectorDescriptorBase)connectorDescriptor);
        }
        return Optional.empty();
    }

    private List<GitRepositoryManagementConnectorDescriptorBase> getAllProjectVotingConnectorDescriptors() throws Exception {
        ProjectConfiguration config = ProjectConfigurationUtils.getProjectConfiguration((IProjectId)this.serviceInfo.getInternalId(), (IndexLayer)this.getIndexLayer());
        return CollectionUtils.mapWithException((Collection)config.getConnectors(), this::getVotingConnectorDescriptor).stream().flatMap(Optional::stream).toList();
    }

    private Optional<GitRepositoryManagementConnectorDescriptorBase> getProjectVotingConnector(String repositoryId) throws StorageException, ProjectConfigurationException {
        MetaIndex projectMetaIndex = this.openProjectIndex(MetaIndex.class, null);
        ProjectConfiguration config = (ProjectConfiguration)projectMetaIndex.getValue(ProjectConfiguration.class);
        try {
            ConnectorConfiguration connector = config.getConnectorByIdentifier(repositoryId);
            return this.getVotingConnectorDescriptor(connector);
        }
        catch (IllegalArgumentException | NoSuchElementException e) {
            return Optional.empty();
        }
    }
}

