/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class MetricServiceUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private static List<MetricDirectoryEntry> filterIncompleteEntries(List<MetricDirectoryEntry> entries, Set<Integer> accessedMetricIndexes) {
        ArrayList<MetricDirectoryEntry> result = new ArrayList<MetricDirectoryEntry>();
        boolean missingEntryWasLogged = false;
        for (MetricDirectoryEntry entry : entries) {
            if (accessedMetricIndexes.stream().anyMatch(index -> entry.getValueWithoutNullAssert(index.intValue()) == null)) {
                if (missingEntryWasLogged) continue;
                LOGGER.error("Encountered incomplete entry: " + entry.getUniformPath());
                missingEntryWasLogged = true;
                continue;
            }
            if (entry.isEntryForArchitectureFile()) continue;
            result.add(entry);
        }
        return result;
    }

    public static List<MetricDirectoryEntry> extractCompleteLeaves(List<MetricDirectoryEntry> entries, Set<Integer> accessedMetricIndexes) {
        List<MetricDirectoryEntry> leaves = MetricServiceUtil.extractLeaves(entries);
        return MetricServiceUtil.filterIncompleteEntries(leaves, accessedMetricIndexes);
    }

    private static List<MetricDirectoryEntry> extractLeaves(List<MetricDirectoryEntry> entries) {
        ArrayList<MetricDirectoryEntry> leaves = new ArrayList<MetricDirectoryEntry>();
        for (MetricDirectoryEntry entry : entries) {
            if (entry.hasChildren()) continue;
            leaves.add(entry);
        }
        return leaves;
    }

    private MetricServiceUtil() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

