/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.history;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.MetricDirectoryIndexSynchronizerBase;
import com.teamscale.core.metrics.directory.TrendIndexBase;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.core.utils.UnresolvedCommitDescriptorUtils;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.ReadCacheEnabled;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.issues.IssueContributor;
import com.teamscale.service.metrics.history.MetricHistoryServiceQueryOptions;
import com.teamscale.service.metrics.history.MetricTrendEntry;
import com.teamscale.service.requirements_tracing.SpecItemContributor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@ReadCacheEnabled(maximumStoreCacheSize=0x40000000L)
@Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class, SpecItemContributor.class, IssueContributor.class})
@Path(value="api/projects/{project}/metrics/history")
public class MetricHistoryService
extends ApiBase {
    @GET
    @Operation(summary="Get metric history", description="Retrieves the metric history for a resource.", tags={"Metrics"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<MetricTrendEntry> getMetricHistory(@Parameter(description="Uniform path to retrieve the metric history for.", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath, @BeanParam MetricHistoryServiceQueryOptions parameters) throws StorageException {
        return MetricHistoryService.getMetricHistory(parameters, uniformPath, (ProjectStorageSystem)this.getProjectStorageSystem(), this.getGlobalStorageSystem(), this.getUser());
    }

    static List<MetricTrendEntry> getMetricHistory(MetricHistoryServiceQueryOptions parameters, UniformPath uniformPath, ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser) throws StorageException {
        CommitDescriptor startCommit = MetricHistoryService.getStartCommit(parameters, projectStorageSystem);
        long now = DateTimeUtils.millisNow();
        CommitDescriptor endCommit = MetricHistoryService.getEndCommit(parameters, projectStorageSystem, now);
        long maxMilliseconds = parameters.getLength();
        if (maxMilliseconds > 0L) {
            endCommit = new CommitDescriptor(endCommit.getBranchName(), 1L + endCommit.getTimestamp());
            startCommit = new CommitDescriptor(startCommit.getBranchName(), Math.max(1L, endCommit.getTimestamp() - maxMilliseconds));
        }
        return MetricHistoryService.calculateMetricHistoryResult(uniformPath, startCommit, endCommit, projectStorageSystem, globalStorageSystem, currentUser, parameters.getPartitions());
    }

    public static List<MetricTrendEntry> calculateMetricHistoryResult(UniformPath uniformPath, CommitDescriptor startCommit, CommitDescriptor endCommit, ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem, User currentUser, @Nullable Set<String> partitions) throws StorageException {
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), partitions, (ProjectStorageSystem)projectStorageSystem, (GlobalStorageSystem)globalStorageSystem, (User)currentUser);
        List elementHistory = metricRetrievalStrategy.extractMetricHistory(uniformPath, startCommit, endCommit);
        MetricHistoryService.addValueForBoundaries(uniformPath, startCommit, endCommit, elementHistory, metricRetrievalStrategy);
        Collections.sort(elementHistory);
        return MetricHistoryService.createResult(elementHistory);
    }

    public static CommitDescriptor getEndCommit(MetricHistoryServiceQueryOptions parameters, ProjectStorageSystem projectStorageSystem, long now) throws StorageException {
        return MetricHistoryService.getCommitForParameters(parameters.getEndCommit(), parameters, projectStorageSystem, now);
    }

    private static CommitDescriptor getStartCommit(MetricHistoryServiceQueryOptions parameters, ProjectStorageSystem projectStorageSystem) throws StorageException {
        return MetricHistoryService.getCommitForParameters(parameters.getStartCommit(), parameters, projectStorageSystem, 1L);
    }

    private static CommitDescriptor getCommitForParameters(UnresolvedCommitDescriptor commit, MetricHistoryServiceQueryOptions parameters, ProjectStorageSystem projectStorageSystem, long timestamp) throws StorageException {
        if (commit.getBranchName() == null && commit.getTimestamp() == Long.MAX_VALUE) {
            String branch = parameters.getBranch();
            if (branch == null) {
                branch = MetricHistoryService.getDefaultBranchName(projectStorageSystem);
            }
            return new CommitDescriptor(branch, timestamp);
        }
        return UnresolvedCommitDescriptorUtils.resolve((UnresolvedCommitDescriptor)commit, () -> projectStorageSystem);
    }

    private static List<MetricTrendEntry> createResult(List<TrendIndexBase.TrendEntry<Object[]>> elementHistory) {
        ArrayList<MetricTrendEntry> serializableElementHistory = new ArrayList<MetricTrendEntry>();
        for (TrendIndexBase.TrendEntry<Object[]> entry : elementHistory) {
            serializableElementHistory.add(new MetricTrendEntry(entry.timestamp(), (Object[])entry.value()));
        }
        return serializableElementHistory;
    }

    private static void addValueForBoundaries(UniformPath uniformPath, CommitDescriptor start, CommitDescriptor end, List<TrendIndexBase.TrendEntry<Object[]>> elementHistory, IMetricRetrievalStrategy metricRetrievalStrategy) throws StorageException {
        if (uniformPath.isIssueQueryPath()) {
            return;
        }
        if (start.getTimestamp() != 1L && (elementHistory.isEmpty() || elementHistory.get(0).timestamp() != start.getTimestamp())) {
            MetricHistoryService.addTrendEntry(uniformPath, start, elementHistory, 0, metricRetrievalStrategy);
        }
        if (elementHistory.isEmpty() || ((TrendIndexBase.TrendEntry)CollectionUtils.getLast(elementHistory)).timestamp() != end.getTimestamp()) {
            CommitDescriptor endDescriptor = end;
            if (end.getTimestamp() > System.currentTimeMillis()) {
                endDescriptor = new CommitDescriptor(end.getBranchName(), DateTimeUtils.millisNow());
            }
            MetricHistoryService.addTrendEntry(uniformPath, endDescriptor, elementHistory, elementHistory.size(), metricRetrievalStrategy);
        }
    }

    private static void addTrendEntry(UniformPath uniformPath, CommitDescriptor commit, List<TrendIndexBase.TrendEntry<Object[]>> elementHistory, int insertionPos, IMetricRetrievalStrategy metricRetrievalStrategy) throws StorageException {
        MetricDirectoryEntry startEntry = metricRetrievalStrategy.getMetricDirectoryEntry(uniformPath, HistoryAccessOption.readCommit((CommitDescriptor)commit));
        if (startEntry == null) {
            MetricDirectorySchema metricDirectorySchema = metricRetrievalStrategy.getMetricDirectorySchema();
            startEntry = MetricDirectoryIndexSynchronizerBase.createMetricDirectoryEntryWithDefaultValue((String)uniformPath.toString(), (MetricDirectorySchema)metricDirectorySchema);
        }
        Object[] values = startEntry.getValues();
        TrendIndexBase.TrendEntry trendEntry = new TrendIndexBase.TrendEntry(commit.getTimestamp(), (Object)values);
        elementHistory.add(insertionPos, (TrendIndexBase.TrendEntry<Object[]>)trendEntry);
    }
}

