/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.schema;

import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.metrics.schema.MetricSchemaService;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.HashMap;
import java.util.Map;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/metric-schemas")
public class MetricSchemasService
extends ApiBase {
    @GET
    @Operation(summary="Get metric schemas", description="Returns all metric schemas of a project.")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public Map<String, MetricDirectorySchema> getMetricDirectorySchemas() throws StorageException {
        HashMap<String, MetricDirectorySchema> metricSchemas = new HashMap<String, MetricDirectorySchema>();
        for (UniformPath.EType pathType : UniformPath.EType.values()) {
            metricSchemas.put(pathType.name(), MetricSchemaService.getSchema(pathType, this.getProjectStorageSystem(), this.getGlobalStorageSystem(), this.getUser()));
        }
        return metricSchemas;
    }
}

