/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.treemap;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.testgap.query.CoverageSourceParameterBase;
import com.teamscale.index.testgap.query.CoverageSourceQueryParameters;
import com.teamscale.index.testgap.treemap.MethodTreeMapNode;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.index.testimpact.MethodIdIndex;
import com.teamscale.service.findings.DeltaAnalysisServiceBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.metrics.treemap.builder.ChangeMethodsTreeMapBuilder;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/test-executions/{testExecution}/related-changes/treemap")
public class ChangesRelatedToTestTreeMapService
extends DeltaAnalysisServiceBase {
    private static final String EXCLUDE_UNCHANGED_METHODS_PARAMETER_NAME = "exclude-unchanged-methods";

    @GET
    @Cache(maxAge=5, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    @Operation(summary="Get change data of testwise coverage methods in treemap", description="Retrieves the changes of methods covered by a test with testwise coverage data.", tags={"Test Gap Analysis"}, responses={@ApiResponse(responseCode="400", description="Could not find actual commit for given branch at given timestamp."), @ApiResponse(responseCode="404", description="Found no testwise coverage data.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public MethodTreeMapNode getRelatedChangesTreemap(@BeanParam CoverageSourceQueryParameters coverageSourceParameters, @BeanParam TimeIntervalBasedServiceQueryOptions timeIntervalBasedParameters, @PathParam(value="testExecution") UniformPath testExecution, @Parameter(description="Parameter determining if only changed methods should be returned") @QueryParam(value="exclude-unchanged-methods") boolean excludeUnchangedMethods) throws StorageException {
        return this.processTreemapRequest((CoverageSourceParameterBase)coverageSourceParameters, timeIntervalBasedParameters, excludeUnchangedMethods, testExecution);
    }

    private MethodTreeMapNode processTreemapRequest(CoverageSourceParameterBase coverageSourceParameters, TimeIntervalBasedServiceQueryOptions timeIntervalBasedParameters, boolean excludeUnchangedMethods, UniformPath testExecution) throws StorageException {
        if (!testExecution.isTestExecutionPath()) {
            throw new BadRequestException("The given path is not a test execution.");
        }
        HistoryAccessOption historyAccessOptionStart = this.determineHistoryOption(timeIntervalBasedParameters.getBaselineCommit());
        HistoryAccessOption historyAccessOptionNow = this.determineHistoryOption(timeIntervalBasedParameters.getEndCommit());
        Set<MethodId> testedNowMethodIds = this.getTestedMethodIds(coverageSourceParameters, testExecution, historyAccessOptionNow);
        ArrayList<AssociatedMethodInfo> testedMethodsNow = new ArrayList<AssociatedMethodInfo>(this.getAssociatedMethodInfos(testedNowMethodIds, historyAccessOptionNow));
        Set<MethodId> testedStartMethodIds = this.getTestedMethodIds(coverageSourceParameters, testExecution, historyAccessOptionStart);
        HashSet addedMethodIds = CollectionUtils.differenceSet(testedNowMethodIds, (Collection[])new Collection[]{testedStartMethodIds});
        Set<AssociatedMethodInfo> addedMethods = this.getAssociatedMethodInfos(addedMethodIds, historyAccessOptionNow);
        long lastPassedTestTimestamp = historyAccessOptionStart.getTimestamp();
        ChangeMethodsTreeMapBuilder treeMapBuilder = new ChangeMethodsTreeMapBuilder(testedMethodsNow, addedMethods, lastPassedTestTimestamp, excludeUnchangedMethods);
        try {
            return treeMapBuilder.buildTreeMap();
        }
        catch (TreeMapBuilderException e) {
            throw new InternalServerErrorException("Exception during creation of treemap.", (Throwable)((Object)e));
        }
    }

    private Set<MethodId> getTestedMethodIds(CoverageSourceParameterBase coverageSourceParameters, UniformPath testUniformPath, HistoryAccessOption historyAccessOption) throws StorageException {
        CoverageUnitToMethodsMapIndex coverageIndex = this.openProjectIndex(CoverageUnitToMethodsMapIndex.class, historyAccessOption);
        Set methodIds = coverageSourceParameters.useAllPartitions() ? coverageIndex.getMethodsCoveredBy(testUniformPath, (Collection)coverageIndex.getPartitions()) : coverageIndex.getMethodsCoveredBy(testUniformPath, (Collection)coverageSourceParameters.getPartitions());
        return methodIds;
    }

    private Set<AssociatedMethodInfo> getAssociatedMethodInfos(Set<MethodId> methodIds, HistoryAccessOption historyAccessOption) throws StorageException {
        MethodIdIndex methodIdIndex = this.openProjectIndex(MethodIdIndex.class, historyAccessOption);
        List methodLocations = methodIdIndex.getMethodLocations(methodIds);
        MethodInfoIndex methodInfoIndex = this.openProjectIndex(MethodInfoIndex.class, historyAccessOption);
        return methodInfoIndex.getAssociatedMethodInfosForExactPathsAndRegions((Collection)methodLocations, true);
    }
}

