/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.monitoring.prometheus.collectors;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.repository.artifact_store.s3.S3ArchiveIndex;
import com.teamscale.service.monitoring.prometheus.collectors.IndexCallbackMetricsProviderBase;
import io.prometheus.metrics.core.metrics.GaugeWithCallback;
import io.prometheus.metrics.model.snapshots.Unit;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.function.BiConsumerWithException;
import org.conqat.lib.commons.function.ConsumerWithException;

public class ArtifactStoreSizeMetricCollector
extends IndexCallbackMetricsProviderBase {
    public ArtifactStoreSizeMetricCollector(IndexLayer indexLayer) {
        super(indexLayer);
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("artifact_storage_size")).labelNames(new String[]{"project", "connector", "type"})).unit(Unit.BYTES)).help("Size of artifacts stored in the artifact store.")).callback(this::collectMetricsForProject).register();
    }

    private void collectMetricsForProject(GaugeWithCallback.Callback cb) {
        this.doForAllProjects((BiConsumerWithException<PublicProjectId, ProjectStorageSystem, StorageException>)((BiConsumerWithException)(publicProjectId, projectStorageSystem) -> this.collectArtifactStoreMetricsForExternalStorageBackend((PublicProjectId)publicProjectId, (ProjectStorageSystem)projectStorageSystem, cb)));
        this.doForAllConnectors((ConsumerWithException<IndexCallbackMetricsProviderBase.ProjectConnectorCallbackInfo, StorageException>)((ConsumerWithException)callbackInfo -> ArtifactStoreSizeMetricCollector.collectArtifactStoreMetricsForConnector(callbackInfo, cb)));
    }

    private void collectArtifactStoreMetricsForExternalStorageBackend(PublicProjectId projectId, ProjectStorageSystem projectStorageSystem, GaugeWithCallback.Callback cb) throws StorageException {
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((IProjectId)projectId, (IndexLayer)this.indexLayer);
        if (projectConfiguration.getExternalStorageBackend() != null) {
            S3ArchiveIndex s3ArchiveIndex = (S3ArchiveIndex)projectStorageSystem.openProjectIndex(S3ArchiveIndex.class, S3ArchiveIndex.createIndexName((String)"external-analysis-data"), null);
            ArtifactStoreSizeMetricCollector.reportMetricFromArchiveIndex(cb, projectId, s3ArchiveIndex, "external-analysis-data");
        }
    }

    private static void collectArtifactStoreMetricsForConnector(IndexCallbackMetricsProviderBase.ProjectConnectorCallbackInfo callbackInfo, GaugeWithCallback.Callback cb) throws StorageException {
        ERepositoryConnector connectorType = ERepositoryConnector.findByReadableName((String)callbackInfo.connector().getType());
        if (connectorType == null) {
            return;
        }
        if (connectorType == ERepositoryConnector.S3) {
            ArtifactStoreSizeMetricCollector.handleS3Connector(cb, callbackInfo);
        }
    }

    private static void handleS3Connector(GaugeWithCallback.Callback cb, IndexCallbackMetricsProviderBase.ProjectConnectorCallbackInfo callbackInfo) throws StorageException {
        ProjectStorageSystem projectStorageSystem = callbackInfo.projectStorageSystem();
        ConnectorConfiguration connectorConfig = callbackInfo.connector();
        S3ArchiveIndex s3ArchiveIndex = (S3ArchiveIndex)projectStorageSystem.openProjectIndex(S3ArchiveIndex.class, S3ArchiveIndex.createIndexName((String)connectorConfig.getIdentifier()), null);
        ArtifactStoreSizeMetricCollector.reportMetricFromArchiveIndex(cb, callbackInfo.projectId(), s3ArchiveIndex, connectorConfig.getIdentifier());
    }

    private static void reportMetricFromArchiveIndex(GaugeWithCallback.Callback cb, PublicProjectId projectId, S3ArchiveIndex s3ArchiveIndex, String identifier) throws StorageException {
        Long garbageArtifactStoreSize;
        Long analyzedArtifactStoreSize;
        Long totalArtifactStoreSize = s3ArchiveIndex.getTotalArtifactStoreSize();
        if (totalArtifactStoreSize != null) {
            cb.call((double)totalArtifactStoreSize.longValue(), new String[]{projectId.projectId, identifier, "total"});
        }
        if ((analyzedArtifactStoreSize = s3ArchiveIndex.getAnalyzedArtifactStoreSize()) != null) {
            cb.call((double)analyzedArtifactStoreSize.longValue(), new String[]{projectId.projectId, identifier, "used"});
        }
        if ((garbageArtifactStoreSize = s3ArchiveIndex.getGarbageArtifactStoreContentSize()) != null) {
            cb.call((double)garbageArtifactStoreSize.longValue(), new String[]{projectId.projectId, identifier, "garbage"});
        }
    }
}

