/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.monitoring.prometheus.collectors;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.service.monitoring.prometheus.collectors.IndexCallbackMetricsProviderBase;
import com.teamscale.service.system.health.HealthMetricsUtils;
import io.prometheus.metrics.core.metrics.GaugeWithCallback;
import io.prometheus.metrics.core.metrics.Info;
import io.prometheus.metrics.model.snapshots.Unit;
import java.util.Map;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.function.SupplierWithException;

public class HealthMetricsCollector
extends IndexCallbackMetricsProviderBase {
    public HealthMetricsCollector(IndexLayer indexLayer) {
        super(indexLayer);
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("workers")).help("Number of workers.")).callback(cb -> HealthMetricsCollector.wrapInStorageExceptionLogger(cb, (SupplierWithException<Double, StorageException>)((SupplierWithException)() -> HealthMetricsUtils.getWorkerCount(indexLayer)))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("workers_load_ratio")).help("Worker load in percent.")).unit(Unit.RATIO)).callback(cb -> HealthMetricsCollector.wrapInStorageExceptionLogger(cb, (SupplierWithException<Double, StorageException>)((SupplierWithException)() -> HealthMetricsUtils.getWorkerLoad(indexLayer)))).register();
        ((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)((GaugeWithCallback.Builder)GaugeWithCallback.builder().name("worker_runtime_seconds")).help("Runtime of workers in seconds")).labelNames(new String[]{"process_id", "worker_id"})).unit(Unit.SECONDS)).callback(cb -> {
            TwoDimHashMap<String, String, Double> runtimes = HealthMetricsUtils.collectWorkerRuntime(indexLayer);
            for (String processId : runtimes.getFirstKeys()) {
                for (Map.Entry runtimePerWorkerId : runtimes.getSecondMap((Object)processId).entrySet()) {
                    cb.call(((Double)runtimePerWorkerId.getValue()).doubleValue(), new String[]{processId, (String)runtimePerWorkerId.getKey()});
                }
            }
        }).register();
        ((Info)((Info.Builder)((Info.Builder)Info.builder().name("version").help("Version of Teamscale.")).labelNames(new String[]{"version"})).register()).setLabelValues(new String[]{String.valueOf(ETeamscaleVersion.CURRENT_VERSION)});
    }
}

