/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.portfolio;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.portfolio.EQualityGoal;
import com.teamscale.index.portfolio.PortfolioManualAssessmentIndex;
import com.teamscale.index.portfolio.QualityGoalManualAssessment;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.task.ETaskStatus;
import com.teamscale.index.task.Task;
import com.teamscale.index.task.TaskIndex;
import com.teamscale.service.admin.ProjectService;
import com.teamscale.service.base.TimeRangeResourceServiceBase;
import com.teamscale.service.portfolio.FindingsQualityGoalAssessment;
import com.teamscale.service.portfolio.IPortfolioOverviewService;
import com.teamscale.service.portfolio.PortfolioFindingsQualityGoal;
import com.teamscale.service.portfolio.PortfolioOptions;
import com.teamscale.service.tasks.TaskSummaryService;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/quality-reports/portfolio-overview")
public class PortfolioOverviewService
extends TimeRangeResourceServiceBase
implements IPortfolioOverviewService {
    @Context
    private ResourceContext resourceContext;

    @Override
    public List<ProjectPortfolioResult> getPortfolioOverview(TimeIntervalBasedServiceQueryOptions timeRange, List<String> selectedLabels) throws StorageException {
        ProjectService resource = (ProjectService)this.resourceContext.getResource(ProjectService.class);
        List<ProjectInfo> projectInfos = resource.getAllProjects(false, true);
        ArrayList<ProjectPortfolioResult> results = new ArrayList<ProjectPortfolioResult>();
        for (ProjectInfo projectInfo : projectInfos) {
            PortfolioOptions portfolioOptions = PortfolioOptions.getOptionsData(this.getIndexLayer(), projectInfo);
            if (!portfolioOptions.includesOneOf(selectedLabels)) continue;
            results.add(this.createPortfolioResult(timeRange, projectInfo, portfolioOptions));
        }
        return results;
    }

    @Override
    public Set<String> getAllProjectPortfolioLabels() throws StorageException {
        List visibleProjects = this.getPermissions().getVisibleProjects(false, true);
        HashSet<String> labels = new HashSet<String>();
        for (ProjectInfo projectInfo : visibleProjects) {
            PortfolioOptions optionData = PortfolioOptions.getOptionsData(this.getIndexLayer(), projectInfo);
            labels.addAll(optionData.getLabels());
        }
        return labels;
    }

    @Override
    public List<QualityGoalManualAssessment> getPortfolioManualAssessments(PublicProjectId projectId) throws StorageException {
        return this.openManualAssessmentIndex(projectId).getAllAssessments();
    }

    @Override
    public void addPortfolioManualAssessment(PublicProjectId projectId, QualityGoalManualAssessment manualAssessment) throws StorageException {
        this.openManualAssessmentIndex(projectId).addAssessment(manualAssessment);
    }

    @Override
    public void removePortfolioManualAssessment(PublicProjectId projectId, QualityGoalManualAssessment manualAssessment) throws StorageException {
        this.openManualAssessmentIndex(projectId).removeAssessment(manualAssessment);
    }

    @Override
    public void updatePortfolioSelectedManualAssessment(PublicProjectId projectId, QualityGoalManualAssessment manualAssessment) throws StorageException {
        this.openManualAssessmentIndex(projectId).setSelectedManualAssessment(manualAssessment);
    }

    private ProjectPortfolioResult createPortfolioResult(TimeIntervalBasedServiceQueryOptions timeRange, ProjectInfo projectInfo, PortfolioOptions portfolioOptions) throws StorageException {
        PublicProjectId publicId = projectInfo.getPrimaryPublicId();
        CommitDescriptor startCommit = timeRange.resolveBaselineCommit(() -> this.getProjectStorageSystem((IProjectId)publicId));
        CommitDescriptor endCommit = timeRange.resolveEndCommit(() -> this.getProjectStorageSystem((IProjectId)publicId));
        FindingsQualityGoalAssessment goalAssessment = this.calculateAssessment(projectInfo, startCommit, endCommit, portfolioOptions.getQualityGoal());
        PortfolioTaskSummary taskSummary = this.getTaskSummary(publicId, startCommit, endCommit);
        return new ProjectPortfolioResult(this.getAnalysisProfileName(publicId), portfolioOptions.getLabels(), goalAssessment, taskSummary);
    }

    private FindingsQualityGoalAssessment calculateAssessment(ProjectInfo projectInfo, CommitDescriptor start, CommitDescriptor end, EQualityGoal criteria) throws StorageException {
        PortfolioFindingsQualityGoal portfolioFindingsQualityGoal = new PortfolioFindingsQualityGoal(projectInfo, this.serviceInfo, criteria);
        portfolioFindingsQualityGoal.calculateFindingsInfo(start, end);
        return new FindingsQualityGoalAssessment(portfolioFindingsQualityGoal);
    }

    private PortfolioManualAssessmentIndex openManualAssessmentIndex(PublicProjectId projectId) throws StorageException {
        return (PortfolioManualAssessmentIndex)this.getProjectStorageSystem((IProjectId)projectId).openProjectIndex(PortfolioManualAssessmentIndex.class, null);
    }

    private String getAnalysisProfileName(PublicProjectId publicId) throws StorageException {
        return ProjectConfigurationUtils.getProjectConfiguration((IProjectId)publicId, (IndexLayer)this.getIndexLayer()).getAnalysisProfileName(CodeScopeAware.DEFAULT_CODE_SCOPE);
    }

    private PortfolioTaskSummary getTaskSummary(PublicProjectId publicId, CommitDescriptor start, CommitDescriptor end) throws StorageException {
        TaskIndex taskIndex = (TaskIndex)this.getIndexLayer().openProjectIndex((IProjectId)publicId, TaskIndex.class, null);
        List allTasks = taskIndex.getAllTasks();
        long numCreated = allTasks.stream().filter(task -> TaskSummaryService.wasCreatedBetween(task, start.getTimestamp(), end.getTimestamp())).count();
        Function<Task, Boolean> mapFilter = task -> task.getLastStatusUpdate() >= start.getTimestamp() && task.getLastStatusUpdate() < end.getTimestamp();
        return new PortfolioTaskSummary(numCreated, TaskSummaryService.toFilteredStatusCountMap(allTasks, mapFilter));
    }

    public record ProjectPortfolioResult(@JsonProperty String analysisProfile, @JsonProperty List<String> portfolioLabels, FindingsQualityGoalAssessment goalResult, @JsonProperty PortfolioTaskSummary taskSummary) {
    }

    public record PortfolioTaskSummary(@JsonProperty long numberOfCreated, @JsonProperty Map<ETaskStatus, Integer> summaryByStatus) {
    }
}

