/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.portfolio;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.teamscale.index.portfolio.EQualityGoalAssessment;
import com.teamscale.index.portfolio.PortfolioManualAssessmentIndex;
import com.teamscale.index.portfolio.QualityGoalManualAssessment;
import com.teamscale.service.portfolio.FindingsQualityGoalAssessment;
import com.teamscale.service.portfolio.PortfolioQualityGoalBase;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=PortfolioQualityGoalAssessment.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=FindingsQualityGoalAssessment.class)})
public abstract class PortfolioQualityGoalAssessment<GOAL extends PortfolioQualityGoalBase> {
    @JsonProperty
    protected GOAL qualityGoal;
    @JsonProperty
    protected EQualityGoalAssessment assessment;
    @JsonProperty
    protected @Nullable QualityGoalManualAssessment manualAssessment;

    public PortfolioQualityGoalAssessment(GOAL qualityGoal) throws StorageException {
        this.qualityGoal = qualityGoal;
        this.assessQualityGoal();
    }

    private void assessQualityGoal() throws StorageException {
        this.runAssessment();
        this.assessment = this.determineAssessmentResult();
        this.manualAssessment = this.retrieveSelectedManualAssessment();
    }

    protected abstract void runAssessment();

    protected abstract boolean isGoalMet();

    protected EQualityGoalAssessment determineAssessmentResult() throws StorageException {
        if (((PortfolioQualityGoalBase)this.qualityGoal).canBeAssessed()) {
            return this.isGoalMet() ? EQualityGoalAssessment.CRITERIA_MET : EQualityGoalAssessment.CRITERIA_NOT_MET;
        }
        return EQualityGoalAssessment.UNKNOWN;
    }

    public QualityGoalManualAssessment retrieveSelectedManualAssessment() throws StorageException {
        PortfolioManualAssessmentIndex manualAssessmentsIndex = (PortfolioManualAssessmentIndex)((PortfolioQualityGoalBase)this.qualityGoal).getProjectStorageSystem().openProjectIndex(PortfolioManualAssessmentIndex.class, null);
        return manualAssessmentsIndex.getSelectedManualAssessment();
    }
}

