/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project.metric_thresholds;

import com.teamscale.core.analysis.configuration.index.MetricThresholdConfigurationIndex;
import com.teamscale.core.analysis.configuration.index.model.MetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdGroup;
import com.teamscale.core.analysis.configuration.index.model.NamedConfigurableObjectBase;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.metric.MetricBadgesConfiguration;
import com.teamscale.core.analysis.configuration.model.option.merge_request_badge.metric.MetricBadgesConfigurationEntry;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.configuration.MetricThresholdConfigurationUtils;
import com.teamscale.index.metrics.threshold.MetricThresholdConfigurationDefaults;
import com.teamscale.index.thresholds.ProjectThresholdConfigurationUtils;
import com.teamscale.service.base.ElementListServiceBase;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.metrics.table.MetricTableServiceUtils;
import com.teamscale.service.permissions.PermissionFilterUtils;
import com.teamscale.service.project.metric_thresholds.MetricsForThresholdProfile;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.intellij.lang.annotations.Language;

@Path(value="api/metric-threshold-configurations")
public class MetricThresholdConfigurationService
extends ElementListServiceBase<MetricThresholdConfiguration> {
    @GET
    @Operation(summary="Get all metric threshold configurations", description="Retrieves all available metric threshold configurations in the system.", tags={"Metrics"})
    @RequiresNoPermission(description="No permissions needed, as the service will only return metric threshold configurations visible to the current user.")
    public List<MetricThresholdConfiguration> getAllMetricThresholdConfigurations() throws StorageException {
        return PermissionFilterUtils.getVisibleMetricThresholdConfigurations(this.getPermissions(), this.getIndex());
    }

    @GET
    @Operation(summary="Get all metric threshold configuration names", description="Retrieves the names of all available metric threshold configurations in the system.", tags={"Metrics"})
    @Path(value="names")
    @RequiresNoPermission(description="No permissions needed, as the service will only return the names of metric threshold configurations visible to the current user.")
    public Set<String> getAllMetricThresholdConfigurationNames(@Parameter(description="Parameter whether to include default configurations.") @QueryParam(value="include-default-configurations") boolean includeDefaultConfigurations) throws StorageException {
        if (!includeDefaultConfigurations) {
            return new HashSet<String>(this.listElementNames());
        }
        HashSet<String> thresholdConfigurationNames = new HashSet<String>();
        thresholdConfigurationNames.addAll(MetricThresholdConfigurationDefaults.DEFAULT_THRESHOLD_CONFIGURATION_NAMES);
        thresholdConfigurationNames.addAll(this.listElementNames());
        return thresholdConfigurationNames;
    }

    @GET
    @Operation(summary="Get all metrics for metric threshold configuration names", description="Retrieves a list, the entries being the metric threshold configuration names and lists of the metrics included in the profile with that name.", tags={"Metrics"})
    @Path(value="metrics")
    @RequiresNoPermission(description="No permissions needed, as the service will only return the metrics and their profiles visible to the current user.")
    public List<MetricsForThresholdProfile> getAllMetricsForThresholdProfiles(@Parameter(description="Project for which to return the metrics for threshold profiles.") @QueryParam(value="project") PublicProjectId projectId) throws StorageException {
        Set<String> thresholdConfigurationNames = this.getAllMetricThresholdConfigurationNames(true);
        ArrayList<MetricsForThresholdProfile> thresholdConfigurationMetrics = new ArrayList<MetricsForThresholdProfile>();
        for (String thresholdConfigurationName : thresholdConfigurationNames) {
            CommitResolvingStorageSystem projectStorageSystem = this.getProjectStorageSystem((IProjectId)projectId);
            MetricThresholdConfiguration thresholdConfiguration = MetricTableServiceUtils.loadThresholdConfiguration(thresholdConfigurationName, IStorageInfo.create((ProjectInfo)this.getIndexLayer().resolveProject((IProjectId)projectId), (ProjectStorageSystem)projectStorageSystem, (GlobalStorageSystem)this.getGlobalStorageSystem()), new MetricSchemaRetrieverFactory((ProjectStorageSystem)projectStorageSystem));
            ArrayList<String> metricNames = new ArrayList<String>();
            for (MetricThresholdGroup metricThresholdGroup : thresholdConfiguration.getMetricThresholdGroupsOfThisConfiguration()) {
                for (MetricThreshold threshold : metricThresholdGroup.getMetricThresholdList()) {
                    metricNames.add(threshold.getMetricName());
                }
            }
            thresholdConfigurationMetrics.add(new MetricsForThresholdProfile(thresholdConfigurationName, metricNames));
        }
        return thresholdConfigurationMetrics;
    }

    @GET
    @Path(value="{metricThresholdConfigurationName}")
    @RequiresNoPermission(description="Built-in metric threshold configurations require no access permissions. For the rest, view permission for the respective configuration is required.")
    @Operation(summary="Get metric threshold configuration", description="Retrieves the metric threshold configuration identified by given name.", tags={"Metrics"}, responses={@ApiResponse(responseCode="404", description="Metric threshold configuration with given name does not exist."), @ApiResponse(responseCode="400", description="Project name parameter must be specified to load a built-in configuration."), @ApiResponse(responseCode="400", description="Metric threshold base configuration specified but not loaded."), @ApiResponse(responseCode="400", description="Loop detected in metric threshold configuration.")})
    public MetricThresholdConfiguration getMetricThresholdConfiguration(@Parameter(description="Project name to load built-in configurations for") @QueryParam(value="project-name") PublicProjectId projectId, @Parameter(description="Parameter indicating if configuration should be loaded together with default configurations.") @QueryParam(value="load-with-base-configurations") boolean fullyLoadConfiguration, @PathParam(value="metricThresholdConfigurationName") String metricThresholdConfigurationName) throws StorageException, MetricThresholdConfigurationException {
        MetricThresholdConfiguration metricThresholdConfiguration = this.loadThresholdConfigurationWithPermissionCheck(projectId, metricThresholdConfigurationName, fullyLoadConfiguration);
        if (fullyLoadConfiguration) {
            return metricThresholdConfiguration.createEvaluatedConfigurationFromBaseConfigurations();
        }
        return metricThresholdConfiguration;
    }

    private MetricThresholdConfiguration loadThresholdConfigurationWithPermissionCheck(PublicProjectId projectId, String metricThresholdConfigurationName, boolean fullyLoadConfiguration) throws StorageException {
        if (MetricThresholdConfigurationDefaults.isBuiltInThresholdConfiguration((String)metricThresholdConfigurationName)) {
            return this.loadBuiltInThresholdConfiguration(metricThresholdConfigurationName, projectId, fullyLoadConfiguration);
        }
        MetricThresholdConfiguration metricThresholdConfiguration = this.getConfigurationWithBase(metricThresholdConfigurationName, fullyLoadConfiguration);
        this.getPermissions().checkBasicPermission(EBasicPermissionScope.METRIC_THRESHOLD_CONFIGURATIONS, metricThresholdConfiguration.getName(), EBasicPermission.VIEW);
        return metricThresholdConfiguration;
    }

    @GET
    @Path(value="{metricThresholdConfigurationName}/deriving-configuration-names")
    @RequiresNoPermission(description="Built-in metric threshold configurations require no access permissions. For the rest, view permission for the respective configuration is required.")
    @Operation(summary="Get names of deriving metric threshold configurations", description="Retrieves names of deriving metric threshold configurations.", tags={"Metrics"})
    public List<String> getDerivingMetricThresholdConfigurationNames(@PathParam(value="metricThresholdConfigurationName") String metricThresholdConfigurationName) throws StorageException {
        if (!MetricThresholdConfigurationDefaults.isBuiltInThresholdConfiguration((String)metricThresholdConfigurationName)) {
            this.getPermissions().checkBasicPermission(EBasicPermissionScope.METRIC_THRESHOLD_CONFIGURATIONS, metricThresholdConfigurationName, EBasicPermission.VIEW);
        }
        ArrayList<String> derivingConfigurations = new ArrayList<String>();
        for (Pair entry : this.getIndex().getAllThresholdConfigurations()) {
            MetricThresholdConfiguration thresholdConfiguration = (MetricThresholdConfiguration)entry.getSecond();
            if (!thresholdConfiguration.hasBaseConfiguration() || !metricThresholdConfigurationName.equals(thresholdConfiguration.getBaseConfigurationName())) continue;
            derivingConfigurations.add(thresholdConfiguration.getName());
        }
        return derivingConfigurations;
    }

    @DELETE
    @RequiresBasicPermission(scope=EBasicPermissionScope.METRIC_THRESHOLD_CONFIGURATIONS, permissions={EBasicPermission.DELETE}, entityPathParameter="metricThresholdConfigurationName")
    @Operation(summary="Delete metric threshold configuration", description="Deletes the metric threshold configuration identified by the given name from the system", tags={"Metrics"}, responses={@ApiResponse(responseCode="404", description="Metric threshold configuration identified by the given name does not exist."), @ApiResponse(responseCode="400", description="Default metric threshold configuration cannot be removed.")})
    @Path(value="{metricThresholdConfigurationName}")
    public void deleteMetricThresholdConfiguration(@Parameter(description="Name of the metric threshold configuration to delete") @PathParam(value="metricThresholdConfigurationName") String metricThresholdConfigurationName) throws StorageException, JsonSerializationException, MetricThresholdConfigurationException {
        if (MetricThresholdConfigurationDefaults.isBuiltInThresholdConfiguration((String)metricThresholdConfigurationName)) {
            throw new BadRequestException("Cannot remove default metric threshold configuration!");
        }
        MetricThresholdConfiguration metricThresholdConfiguration = (MetricThresholdConfiguration)this.getElementWithExistsCheck(metricThresholdConfigurationName);
        MetricUsages metricUsages = this.checkMetricUsage(metricThresholdConfiguration, false);
        if (!metricUsages.projectIds().isEmpty()) {
            throw new BadRequestException(metricUsages.print());
        }
        this.deleteElementAndPermissions(metricThresholdConfiguration);
    }

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_METRIC_THRESHOLD_CONFIGURATIONS})
    @Operation(summary="Create metric threshold configuration", description="Creates a new metric threshold configuration.", tags={"Metrics"}, responses={@ApiResponse(responseCode="400", description="Provided metric threshold configuration not consistent."), @ApiResponse(responseCode="400", description="Metric threshold base configuration specified but not loaded."), @ApiResponse(responseCode="400", description="Loop detected in metric threshold configuration."), @ApiResponse(responseCode="400", description="Assessment specification is not set."), @ApiResponse(responseCode="400", description="Invalid sub path for threshold with metric from source schema."), @ApiResponse(responseCode="400", description="One of the groups contains a threshold with a non-unique display name.")})
    public void createMetricThresholdConfiguration(@RequestBody(required=true) MetricThresholdConfiguration newValue) throws StorageException {
        if (MetricThresholdConfigurationDefaults.isBuiltInThresholdConfiguration((String)newValue.getName())) {
            throw new BadRequestException("Cannot create a metric threshold configuration with the name of the default threshold configuration '%s'. Please choose a different name for the threshold configuration.".formatted(newValue.getName()));
        }
        this.createElementAndPermissions(newValue);
    }

    @PUT
    @RequiresNoPermission(description="Requires the edit permission for the respective metric threshold configuration.")
    @Operation(summary="Update metric threshold configuration", description="Updates the metric threshold configuration identified by the given name with the value in the request body.", tags={"Metrics"}, responses={@ApiResponse(responseCode="404", description="Metric threshold configuration with given name does not exist.")})
    public void updateMetricThresholdConfiguration(@RequestBody(required=true) MetricThresholdConfiguration newValue) throws StorageException, JsonSerializationException, MetricThresholdConfigurationException {
        MetricUsages usedMetrics = this.checkMetricUsage(newValue, true);
        if (!usedMetrics.projectIds().isEmpty()) {
            throw new BadRequestException(usedMetrics.print());
        }
        String metricThresholdConfigurationName = newValue.getName();
        MetricThresholdConfiguration metricThresholdConfiguration = (MetricThresholdConfiguration)this.getElementWithExistsCheck(metricThresholdConfigurationName);
        this.updateElement(metricThresholdConfiguration, newValue);
    }

    private MetricUsages checkMetricUsage(MetricThresholdConfiguration configuration, boolean reportUsedMetrics) throws StorageException, JsonSerializationException, MetricThresholdConfigurationException {
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        List allProjectInfos = projectIndex.getAllPrimaryPublicProjectIds();
        List projectConfigurations = ProjectConfigurationUtils.getProjectConfigurations((List)allProjectInfos, (IndexLayer)this.getIndexLayer());
        MetricUsages usedMetrics = new MetricUsages();
        for (ProjectConfiguration projectConfiguration : projectConfigurations) {
            List<String> optionValues = projectConfiguration.getConnectors().stream().flatMap(c -> Stream.of(c.getOptionValue("Badges for Metrics"), c.getOptionValue("Badges for Metric Groups"))).filter(Objects::nonNull).toList();
            for (String optionValue : optionValues) {
                usedMetrics.merge(MetricThresholdConfigurationService.checkMetricUsageForProject(projectConfiguration.getPrimaryPublicId(), configuration, reportUsedMetrics, optionValue));
            }
        }
        return usedMetrics;
    }

    private static MetricUsages checkMetricUsageForProject(PublicProjectId projectId, MetricThresholdConfiguration configuration, boolean reportUsedMetrics, @Language(value="JSON") String optionValue) throws JsonSerializationException, MetricThresholdConfigurationException {
        MetricUsages usedMetrics = new MetricUsages();
        MetricBadgesConfiguration metricBadgesConfiguration = (MetricBadgesConfiguration)JsonUtils.deserializeFromJson((String)optionValue, MetricBadgesConfiguration.class);
        List<MetricBadgesConfigurationEntry> usedMetricEntries = metricBadgesConfiguration.getConfiguredBadges().stream().filter(e -> e.thresholdConfigurationName().equals(configuration.getName())).toList();
        for (MetricBadgesConfigurationEntry entry : usedMetricEntries) {
            Optional threshold = configuration.findThreshold(entry.metricThresholdGroupName(), entry.metricName());
            if (threshold.isEmpty() != reportUsedMetrics) continue;
            usedMetrics.addProjectId(projectId);
            usedMetrics.addMetricName(entry.metricName());
        }
        return usedMetrics;
    }

    private MetricThresholdConfiguration getConfigurationWithBase(String thresholdConfigurationName, boolean fullyLoadConfiguration) throws StorageException {
        MetricThresholdConfiguration thresholdConfiguration = fullyLoadConfiguration ? this.getElement(thresholdConfigurationName) : this.getIndex().getConfigurationWithoutLoadingBaseConfiguration(thresholdConfigurationName);
        if (thresholdConfiguration == null) {
            throw new NotFoundException("Threshold configuration with name " + thresholdConfigurationName + " could not be found.");
        }
        return thresholdConfiguration;
    }

    private MetricThresholdConfiguration loadBuiltInThresholdConfiguration(String thresholdConfigurationName, PublicProjectId projectId, boolean fullyLoadConfiguration) throws StorageException {
        if (projectId == null) {
            throw new BadRequestException("Project ID must be specified to load a built-in configuration");
        }
        CommitResolvingStorageSystem projectStorageSystem = this.getIndexLayer().openProjectStorageSystem((IProjectId)projectId);
        return ProjectThresholdConfigurationUtils.getThresholdConfiguration((String)thresholdConfigurationName, (IStorageInfo)IStorageInfo.create((ProjectInfo)this.getIndexLayer().resolveProject((IProjectId)projectId), (ProjectStorageSystem)projectStorageSystem, (GlobalStorageSystem)this.getGlobalStorageSystem()), (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory((ProjectStorageSystem)projectStorageSystem), (boolean)fullyLoadConfiguration);
    }

    @Override
    protected MetricThresholdConfiguration getElement(String thresholdConfigurationName) throws StorageException {
        return this.getIndex().getConfigurationAndLoadBaseConfiguration(thresholdConfigurationName);
    }

    @Override
    protected void updateElement(MetricThresholdConfiguration oldElement, MetricThresholdConfiguration newElement) throws StorageException {
        this.validateElement(newElement);
        this.getIndex().setThresholdConfiguration(newElement);
    }

    @Override
    protected void createElementAndPermissions(MetricThresholdConfiguration newElement) throws StorageException {
        this.validateElement(newElement);
        super.createElementAndPermissions(newElement);
    }

    @Override
    protected void createElement(MetricThresholdConfiguration newElement) throws StorageException {
        this.validateElement(newElement);
        this.getIndex().setThresholdConfiguration(newElement);
    }

    @Override
    protected void deleteElement(MetricThresholdConfiguration elementToDelete) throws StorageException {
        this.getIndex().removeThresholdConfiguration(elementToDelete.getName());
    }

    protected MetricThresholdConfigurationIndex getIndex() throws StorageException {
        return this.openGlobalIndex(MetricThresholdConfigurationIndex.class);
    }

    private void validateElement(MetricThresholdConfiguration metricThresholdConfiguration) throws StorageException, InternalServerErrorException {
        try {
            MetricThresholdConfigurationUtils.validateMetricThresholdConfiguration((MetricThresholdConfiguration)metricThresholdConfiguration, (MetricThresholdConfigurationIndex)this.getIndex(), (GlobalStorageSystem)this.getGlobalStorageSystem());
        }
        catch (MetricThresholdConfigurationException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    private List<String> listElementNames() throws StorageException {
        return CollectionUtils.map(PermissionFilterUtils.getVisibleMetricThresholdConfigurations(this.getPermissions(), this.getIndex()), NamedConfigurableObjectBase::getName);
    }

    @Override
    protected void createPermissions(MetricThresholdConfiguration newElement) throws StorageException {
        this.getPermissions().createPermissionModifier().makeCurrentUserOwner(EBasicPermissionScope.METRIC_THRESHOLD_CONFIGURATIONS, newElement.getName());
    }

    @Override
    protected void deletePermissions(MetricThresholdConfiguration deletedElement) throws StorageException {
        this.getPermissions().createPermissionModifier().removeBasicRoleInstanceAssignments(EBasicPermissionScope.METRIC_THRESHOLD_CONFIGURATIONS, deletedElement.getName());
    }

    record MetricUsages(Set<PublicProjectId> projectIds, Set<String> metricNames) {
        MetricUsages() {
            this(new HashSet<PublicProjectId>(), new HashSet<String>());
        }

        public void addProjectId(PublicProjectId projectId) {
            this.projectIds.add(projectId);
        }

        public void addMetricName(String metricName) {
            this.metricNames.add(metricName);
        }

        public void merge(MetricUsages newMetricUsages) {
            this.projectIds.addAll(newMetricUsages.projectIds);
            this.metricNames.addAll(newMetricUsages.metricNames);
        }

        public String print() {
            List<String> sortedIds = this.projectIds.stream().map(i -> i.projectId).sorted().toList();
            String formattedIds = StringUtils.joinDifferentLastDelimiter(sortedIds, (String)",", (String)"and");
            List sortedMetricNames = this.metricNames.stream().sorted().toList();
            String formattedNames = StringUtils.joinDifferentLastDelimiter(sortedMetricNames, (String)",", (String)"and");
            return String.format("These metrics are still being used: %s. Update the project configuration of these projects and remove the metric usage: %s", formattedNames, formattedIds);
        }
    }
}

