/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.repository.ProjectRepositoryChangeIndex;
import com.teamscale.index.repository.git.GitRepositoryConnectorDescriptor;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.repository.BranchesInfo;
import com.teamscale.service.repository.ProjectBranchesService;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.core.pattern.PatternList;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/projects/{project}/important-branches")
public class ProjectImportantBranchesService
extends ApiBase {
    @GET
    @Operation(summary="Get the names of the important branches", description="Get the names of the important branches", tags={"Project"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<String> getImportantBranches() throws StorageException {
        return ProjectImportantBranchesService.getImportantBranches((MetaIndex)this.getProjectStorageSystem().openProjectIndex(MetaIndex.class, null), this.getPermissions(), this.getUser(), this.openProjectIndex(ProjectRepositoryChangeIndex.class, null)).toList();
    }

    public static @NonNull Stream<String> getImportantBranches(MetaIndex meta, ServicePermissions permissions, User user, ProjectRepositoryChangeIndex projectRepositoryChangeIndex) throws StorageException {
        PatternList importantBranchPatterns;
        ProjectConfiguration config = (ProjectConfiguration)meta.getValue(ProjectConfiguration.class);
        List patternStrings = config.getConnectors().stream().map(connector -> connector.getOptionValue("Important Branches")).filter(Objects::nonNull).flatMap(string -> CollectionUtils.parseMultiValueStringToList((String)string, (boolean)true).stream()).toList();
        try {
            importantBranchPatterns = GitRepositoryConnectorDescriptor.compileImportantBranchPatterns(patternStrings);
        }
        catch (ConnectorValidationException e) {
            throw new IllegalStateException(e);
        }
        BranchesInfo branchInfo = ProjectBranchesService.getBranchesInfo(permissions, false, projectRepositoryChangeIndex, user.getUsername());
        return Stream.of(branchInfo.getLiveBranches(), branchInfo.getDeletedBranches(), branchInfo.getAnonymousBranches()).flatMap(Collection::stream).filter(arg_0 -> ((PatternList)importantBranchPatterns).matchesAny(arg_0));
    }
}

