/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/revision/{revision}/commits")
public class RepositoryTimestampByRevisionService
extends ApiBase {
    @GET
    @Operation(summary="Get teamscale commits", tags={"Connectors"}, description="Returns the teamscale commit representations for a given revision. As a revision can occur in multiple repositories, more than one commit may be returned.")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @PublicApi(since=ETeamscaleVersion.VERSION_5_9_6)
    public List<CommitDescriptor> getCommitsForRevision(@PathParam(value="revision") String revision) throws StorageException {
        RepositoryRevisionIndex index = this.openProjectIndex(RepositoryRevisionIndex.class, null);
        return index.getKnownRepositoryCommits(revision).extractFirstList().stream().distinct().toList();
    }
}

