/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.external.update.ExternalResultsPartitionLastUpdateIndex;
import com.teamscale.index.testcoverage.LineCoverageIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.parameter.ResolveToCodePath;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.resource.TestCoveragePartitionInfo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/test-coverage-partitions/{uniformPath: .*}")
public class LineCoveragePartitionService
extends ApiBase {
    @GET
    @PublicApi(since=ETeamscaleVersion.VERSION_5_3_0)
    @Operation(summary="Line Coverage Partitions", description="Returns the line coverage partitions for an element.", tags={"Test Coverage"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<TestCoveragePartitionInfo> getLineCoveragePartitionsForPath(@PathParam(value="uniformPath") @ResolveToCodePath UniformPath uniformPath, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        LineCoverageIndex coverageIndex = this.openProjectIndex(LineCoverageIndex.class, historyAccessOption);
        List partitions = coverageIndex.getPartitions();
        List coverageInfos = coverageIndex.getAllCoverageForFile(partitions, uniformPath);
        ArrayList<TestCoveragePartitionInfo> result = new ArrayList<TestCoveragePartitionInfo>();
        ExternalResultsPartitionLastUpdateIndex partitionLastUpdateIndex = this.openProjectIndex(ExternalResultsPartitionLastUpdateIndex.class, historyAccessOption);
        Map lastUploadByPartition = CollectionUtils.zipAsMap((SequencedCollection)partitions, (SequencedCollection)partitionLastUpdateIndex.getLastUpdatedCommits(partitions));
        String uniformPathString = uniformPath.toString();
        CollectionUtils.forEach((Iterable)partitions, (Iterable)coverageInfos, (partition, coverageInfo) -> {
            if (coverageInfo == null && lastUploadByPartition.containsKey(partition)) {
                LogManager.getLogger().warn("Partition '{}' exists, but does not contain any coverage for the given uniform path: {}", partition, (Object)uniformPathString);
            } else if (coverageInfo != null) {
                CommitDescriptor lastUpload = (CommitDescriptor)lastUploadByPartition.get(partition);
                long lastUploadTimestamp = coverageInfo.getUploadCommitTimestamp();
                if (lastUpload != null) {
                    lastUploadTimestamp = lastUpload.getTimestamp();
                }
                TestCoveragePartitionInfo partitionInfo = new TestCoveragePartitionInfo((String)partition, lastUploadTimestamp);
                result.add(partitionInfo);
            }
        });
        return result;
    }
}

