/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.FormattedTokenElementInfo;
import com.teamscale.index.resource.PreprocessorExpansionsIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.parameter.ResolveToCodePath;
import eu.cqse.check.framework.preprocessor.c.PreprocessorIncludeTokenReplacement;
import eu.cqse.check.framework.preprocessor.c.PreprocessorTokenReplacement;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/preprocessor-expansions")
public class PreprocessorExpansionsService
extends ApiBase {
    private static final String EXPANSION_ID_QUERY_NAME = "expansionGroupIds";
    private static final String EXPANSION_ID_QUERY_DESCRIPTION = "Identifier (number) of the requested expansion group. The numbers are given by the \"basicInfo\" service endpoint.";

    @GET
    @Path(value="{uniformPath: .*}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Returns the basic preprocessor information for a file", description="", tags={"Source Code"})
    public PreprocessorExpansionsTransport getBasicPreprocessorExpansionsInfo(@PathParam(value="uniformPath") @ResolveToCodePath UniformPath uniformPath, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        List replacements = this.openProjectIndex(PreprocessorExpansionsIndex.class, historyAccessOption).getExpansionsForUniformPath(uniformPath);
        if (CollectionUtils.isNullOrEmpty((Collection)replacements)) {
            return new PreprocessorExpansionsTransport();
        }
        TokenElementInfo tokenElement = this.openProjectIndex(TokenElementIndex.class, "content", historyAccessOption).getTokenElementByPath(uniformPath);
        if (tokenElement == null) {
            throw new IllegalArgumentException("Cannot find file with path: " + String.valueOf(uniformPath));
        }
        HistoryAccessOption resolvedHistoryAccessOption = this.getProjectStorageSystem().resolveHistoryAccessOptionCached(historyAccessOption, PreprocessorExpansionsIndex.class, Optional.empty());
        CommitDescriptor resolvedCommit = new CommitDescriptor(resolvedHistoryAccessOption.getBranchName(), resolvedHistoryAccessOption.getTimestamp());
        return PreprocessorExpansionsService.generateReplacementRegionsTransport((UnmodifiableList<PreprocessorTokenReplacement>)CollectionUtils.asUnmodifiable((List)replacements), tokenElement, resolvedCommit);
    }

    private static @NonNull PreprocessorExpansionsTransport generateReplacementRegionsTransport(UnmodifiableList<PreprocessorTokenReplacement> replacements, TokenElementInfo tokenElement, CommitDescriptor commit) {
        UnmodifiableList tokens = tokenElement.getTokens();
        PreprocessorExpansionsTransport result = new PreprocessorExpansionsTransport();
        for (int i = 0; i < replacements.size(); ++i) {
            PreprocessorTokenReplacement replacement = (PreprocessorTokenReplacement)replacements.get(i);
            for (int tokenOffset : PreprocessorExpansionsService.getOffsetsOfReplacedOriginalTokens(replacement, (UnmodifiableList<IToken>)tokens)) {
                result.offsetToExpansionGroup.put(tokenOffset, i);
            }
            if (!(replacement instanceof PreprocessorIncludeTokenReplacement) || !((PreprocessorIncludeTokenReplacement)replacement).includedFileIsVisible) continue;
            result.expansionGroupToIncludedPath.put(i, ((PreprocessorIncludeTokenReplacement)replacement).uniformPathOfIncludedFile);
        }
        result.commit = commit;
        return result;
    }

    private static ArrayList<Integer> findLineBreaks(String text) {
        ArrayList<Integer> lineBreakIndices = new ArrayList<Integer>();
        int i = 0;
        while (i != -1) {
            if ((i = text.indexOf(10, i)) == -1) continue;
            lineBreakIndices.add(i);
            ++i;
        }
        return lineBreakIndices;
    }

    @GET
    @Path(value="{uniformPath: .*}/expansions")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Returns a specific token-expansion (i.e., the result of one macro or directive expansion/replacement). This service should be called with the commit returned by the preprocessor-expansions endpoint to achieve correct results (the file contents might have changed in the meantime).", description="", tags={"Source Code"})
    public List<SinglePreprocessorExpansionTransport> getSinglePreprocessorExpansion(@PathParam(value="uniformPath") UniformPath uniformPath, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit, @QueryParam(value="expansionGroupIds") @Parameter(description="Identifier (number) of the requested expansion group. The numbers are given by the \"basicInfo\" service endpoint.") List<Integer> expansionGroupIds) throws StorageException, BadRequestException {
        uniformPath = uniformPath.resolveToCodePath();
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        List replacements = this.openProjectIndex(PreprocessorExpansionsIndex.class, historyAccessOption).getExpansionsForUniformPath(uniformPath);
        if (CollectionUtils.isNullOrEmpty((Collection)replacements)) {
            throw new BadRequestException("Requested a preprocessor expansion group, but the given file has none.");
        }
        if (expansionGroupIds.stream().anyMatch(expansionGroupId -> !CollectionUtils.isValidIndex((int)expansionGroupId, (List)replacements))) {
            throw new BadRequestException("Requested expansion groups " + String.valueOf(expansionGroupIds) + ", but the file " + String.valueOf(uniformPath) + " has only " + replacements.size() + " expansion groups.");
        }
        TokenElementInfo tokenElement = this.openProjectIndex(TokenElementIndex.class, "content", historyAccessOption).getTokenElementByPath(uniformPath);
        ArrayList<SinglePreprocessorExpansionTransport> expansions = new ArrayList<SinglePreprocessorExpansionTransport>();
        for (int expansionGroupId2 : expansionGroupIds) {
            PreprocessorTokenReplacement replacement = (PreprocessorTokenReplacement)replacements.get(expansionGroupId2);
            ArrayList<Integer> tokenOffsetsAndStyles = new ArrayList<Integer>();
            ArrayList<FormattedTokenElementInfo.TokenStyle> tokenStyles = new ArrayList<FormattedTokenElementInfo.TokenStyle>();
            List<IToken> replacementTokens = PreprocessorExpansionsService.generateReplacementTokensWithOffsets(replacement);
            FormattedTokenElementInfo.insertStyledTokens((ELanguage)tokenElement.getLanguage(), (String)tokenElement.getText(), replacementTokens, tokenOffsetsAndStyles, tokenStyles, Collections.emptyList());
            String replacementText = TokenStreamTextUtils.concatTokenTexts((List)replacement.getReplacementTokens(), (String)" ");
            expansions.add(new SinglePreprocessorExpansionTransport(replacementText, PreprocessorExpansionsService.getOffsetsOfReplacedOriginalTokens(replacement, (UnmodifiableList<IToken>)tokenElement.getTokens()), tokenOffsetsAndStyles, tokenStyles));
        }
        return expansions;
    }

    private static List<Integer> getOffsetsOfReplacedOriginalTokens(PreprocessorTokenReplacement replacement, UnmodifiableList<IToken> tokens) {
        ArrayList<Integer> replacedTokensOffsets = new ArrayList<Integer>();
        for (int i = replacement.originalTokensStartIndex; i < replacement.originalTokensEndIndex; ++i) {
            IToken expandedToken = (IToken)tokens.get(i);
            if (i == replacement.originalTokensEndIndex - 1 && expandedToken.getType() == ETokenType.EOL) break;
            int expandedTokenStartOffset = ((IToken)tokens.get(i)).getOffset();
            replacedTokensOffsets.add(((IToken)tokens.get(i)).getOffset());
            for (int indexOfLineBreak : PreprocessorExpansionsService.findLineBreaks(expandedToken.getText())) {
                replacedTokensOffsets.add(expandedTokenStartOffset + indexOfLineBreak + 1);
            }
        }
        return replacedTokensOffsets;
    }

    private static List<IToken> generateReplacementTokensWithOffsets(PreprocessorTokenReplacement replacement) {
        ArrayList<IToken> replacementTokens = new ArrayList<IToken>();
        int offsetInReplacement = 0;
        for (IToken replacementToken : replacement.getReplacementTokens()) {
            String text = replacementToken.getText();
            replacementTokens.add(replacementToken.newToken(replacementToken.getType(), offsetInReplacement, 0, text, replacementToken.getOriginId()));
            offsetInReplacement += text.length() + 1;
        }
        return replacementTokens;
    }

    public static class PreprocessorExpansionsTransport {
        @JsonProperty(value="commit")
        private @Nullable CommitDescriptor commit = null;
        @JsonProperty(value="offsetToExpansionGroup")
        private Map<Integer, Integer> offsetToExpansionGroup = new HashMap<Integer, Integer>();
        @JsonProperty(value="expansionGroupToIncludedPath")
        private Map<Integer, String> expansionGroupToIncludedPath = new HashMap<Integer, String>();
    }

    public static class SinglePreprocessorExpansionTransport {
        @JsonProperty(value="replacementText")
        private final String replacementText;
        @JsonProperty(value="tokensOffsetsAndStyles")
        private final List<Integer> tokenOffsetsAndStyles;
        @JsonProperty(value="styles")
        private final List<FormattedTokenElementInfo.TokenStyle> styles;
        @JsonProperty(value="offsetsOfReplacedOriginalTokens")
        private final List<Integer> offsetsOfReplacedOriginalTokens;

        public SinglePreprocessorExpansionTransport(String replacementText, List<Integer> offsetsOfReplacedOriginalTokens, List<Integer> tokenOffsetsAndStyles, List<FormattedTokenElementInfo.TokenStyle> tokenStyles) {
            this.replacementText = replacementText;
            this.offsetsOfReplacedOriginalTokens = offsetsOfReplacedOriginalTokens;
            this.tokenOffsetsAndStyles = tokenOffsetsAndStyles;
            this.styles = tokenStyles;
        }
    }
}

