/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource.debug;

import com.google.common.collect.Lists;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.framework.util.CsvServiceUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.supercsv.io.CsvListWriter;

@Path(value="api/projects/{project}/tokens/debug/token-type-count")
@Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
public class DebugTokenTypeCountService
extends ApiBase {
    @PathParam(value="project")
    private String project;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @GET
    @Operation(summary="Count token types.", description="Returns token types in CSV format.", tags={"Debugging"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public Response countTokenTypes(@Parameter(description="The programming language to count tokens for. If omitted, all languages are considered.") @QueryParam(value="language") ELanguage language, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        TokenElementIndex tokenIndex = this.openProjectIndex(TokenElementIndex.class, "content", historyAccessOption);
        CounterSet counters = new CounterSet();
        List codePaths = UniformPathCompatibilityUtil.convertCollection((Collection)tokenIndex.getAllUniformPaths());
        for (List pathsInBatch : Lists.partition((List)codePaths, (int)500)) {
            @Nullable List tokenElementsInBatch = tokenIndex.getTokenElementsForPaths(pathsInBatch);
            for (TokenElementInfo element : tokenElementsInBatch) {
                if (element == null) continue;
                if (language != null) {
                    if (element.getLanguage() != language) continue;
                }
                element.getTokens().stream().map(IToken::getType).forEach(arg_0 -> ((CounterSet)counters).inc(arg_0));
            }
        }
        return CsvServiceUtils.createCsvResponse((String)("token-type-counts-" + FileSystemUtils.toValidFileName((String)this.project)), csvListWriter -> DebugTokenTypeCountService.createCsvContent((CounterSet<ETokenType>)counters, csvListWriter));
    }

    private static void createCsvContent(CounterSet<ETokenType> counters, CsvListWriter writer) throws IOException {
        writer.writeHeader(new String[]{"Token Type", "Count"});
        for (ETokenType type : counters.getKeysByValueDescending()) {
            writer.write(new Object[]{type.name(), counters.getValue((Object)type)});
        }
    }
}

