/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.search;

import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.user.User;
import com.teamscale.index.issues.IssueIndex;
import com.teamscale.index.repository.IRepositoryLogEntry;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.index.search.ESearchTokenSourceType;
import com.teamscale.index.search.InvertedCodeSearchIndex;
import com.teamscale.index.search.SearchSource;
import com.teamscale.service.commits.LogEntryResolver;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.metrics.treemap.FilteredTreeMapWrapper;
import com.teamscale.service.metrics.treemap.TreemapQueryOptions;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import com.teamscale.service.search.RegularCodeSearchTreeMapBuilder;
import com.teamscale.service.search.SearchAutocompletionService;
import com.teamscale.service.search.SearchQuery;
import com.teamscale.service.search.SearchResultContainer;
import com.teamscale.service.search.SearchResultsCsvBuilder;
import com.teamscale.service.search.SearchServiceBase;
import com.teamscale.service.search.result.CommitSearchFilter;
import com.teamscale.service.search.result.FileSearchHit;
import com.teamscale.service.search.result.SearchHitBase;
import com.teamscale.service.search.result.SearchResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/search")
public class SearchService
extends SearchServiceBase {
    private int numberOfHits = 0;
    private final List<SearchHitBase> searchHits = new ArrayList<SearchHitBase>();
    private int currentPage = 1;
    private static final int DEFAULT_RESULTS_LIMIT_PER_PAGE = 10;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int NO_RESULTS_LIMIT = 0;

    @GET
    @Operation(summary="Search code, issues, commits", description="Provides the possibility to search the indexed code base.", tags={"Project", "Issues", "Source Code"})
    @RequiresNoPermission(description="The service will only search through projects visible to current user.")
    public SearchResultContainer getSearchResults(@Parameter(description="The query string.") @QueryParam(value="query") String query, @Parameter(description="The project the search should be restricted to.") @QueryParam(value="project") PublicProjectId project, @Parameter(description="Which page of the search results to return") @QueryParam(value="page") int page, @Parameter(description="The maximum number of search results per page") @QueryParam(value="limit-per-page") Integer limitPerPage, @Parameter(description="In which sources to search.") @QueryParam(value="source") Set<SearchQuery.EQueryType> sources, @Parameter(description="The sub-path to use as search scope (optional)") @QueryParam(value="path") @Nullable UniformPath uniformPath, @BeanParam @Nullable TreemapQueryOptions treemapRequestOptions) throws StorageException {
        if (limitPerPage == null) {
            limitPerPage = 10;
        }
        if (sources.isEmpty()) {
            sources = EnumSet.allOf(SearchQuery.EQueryType.class);
        }
        if (uniformPath == null) {
            uniformPath = UniformPath.codeRoot();
        }
        if (treemapRequestOptions != null) {
            this.setAreaAndColorIndex(treemapRequestOptions, uniformPath, project);
        }
        return this.createSearchResult(query, project, page, sources, uniformPath, limitPerPage, treemapRequestOptions);
    }

    @GET
    @Path(value="csv")
    @Operation(summary="Search code, issues, commits", description="Provides the possibility to search the indexed code base.", tags={"Project", "Issues", "Source Code"}, responses={@ApiResponse(responseCode="200", description="The search results in csv format", content={@Content(mediaType="text/csv", schema=@Schema(type="string"))})})
    @RequiresNoPermission(description="The service will only search through projects visible to current user.")
    @Produces(value={"text/csv"})
    public Response downloadSearchResultCsv(@Parameter(description="The query string.", required=true) @QueryParam(value="query") String query, @Parameter(description="In which source to search.", required=true) @QueryParam(value="source") SearchQuery.EQueryType source, @Parameter(description="The project the search should be restricted to.") @QueryParam(value="project") PublicProjectId project, @Parameter(description="The sub-path to use as search scope (optional)") @QueryParam(value="path") @Nullable UniformPath uniformPath) throws StorageException {
        if (uniformPath == null) {
            uniformPath = UniformPath.codeRoot();
        }
        SearchResultContainer results = this.createSearchResult(query, project, 1, Collections.singleton(source), uniformPath, 0, null);
        return SearchResultsCsvBuilder.createCsv(results, source);
    }

    private @Nullable FilteredTreeMapWrapper buildCodeSearchTreemapForResults(String query, Set<SearchQuery.EQueryType> sources, TreemapQueryOptions treemapRequestOptions, UniformPath path) {
        if (!sources.contains((Object)SearchQuery.EQueryType.CODE) || this.project == null) {
            return null;
        }
        try {
            IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)path.getType(), (ProjectStorageSystem)this.getProjectStorageSystem((IProjectId)this.project), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser(), (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory((ProjectStorageSystem)this.getProjectStorageSystem((IProjectId)this.project)));
            treemapRequestOptions.adjustTreemapRequestOptions(metricRetrievalStrategy.getMetricDirectorySchema(), false);
            RegularCodeSearchTreeMapBuilder codeSearchTreeMapBuilder = new RegularCodeSearchTreeMapBuilder(query, metricRetrievalStrategy, HistoryAccessOption.readHead((String)this.getDefaultBranchName((IProjectId)this.project)), treemapRequestOptions.areaMetricIndex, treemapRequestOptions.colorMetricIndex, treemapRequestOptions.colorMetricDefaultValue, treemapRequestOptions.baseColor, true, this.searchHits);
            return codeSearchTreeMapBuilder.getWrapper(path);
        }
        catch (TreeMapBuilderException | StorageException e) {
            LOGGER.error("Error building treemap for query " + query, (Throwable)e);
            return null;
        }
    }

    private SearchResultContainer createSearchResult(String searchQuery, PublicProjectId project, int page, Set<SearchQuery.EQueryType> sources, @NonNull UniformPath path, int limitPerPage, @Nullable TreemapQueryOptions treemapRequestOptions) throws StorageException {
        if (StringUtils.isEmpty((String)searchQuery)) {
            return new SearchResultContainer((List<SearchResult>)CollectionUtils.emptyList(), null, 0, 0, 0);
        }
        this.project = project;
        this.fillSearchHits(SearchQuery.parse(searchQuery, sources));
        Set<String> includedArchitectureFiles = this.getIncludedArchitectureFiles(path);
        if (!path.isRoot()) {
            this.searchHits.removeIf(hit -> hit.getSource().getSourceType() == ESearchTokenSourceType.CODE && !SearchService.shouldFileBeIncludedInSearch(hit.getSource().getSourceName(), includedArchitectureFiles, path));
        }
        if (sources.contains((Object)SearchQuery.EQueryType.FILES)) {
            ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
            Set<SearchAutocompletionService.SearchSuggestion> suggestions = this.determineFileSuggestions(searchQuery, 0, projectIndex, false);
            suggestions.stream().filter(suggestion -> suggestion.type() == SearchAutocompletionService.ESearchSuggestionType.FILE && SearchService.shouldFileBeIncludedInSearch(suggestion.title(), includedArchitectureFiles, path)).forEach(suggestion -> this.searchHits.add(new FileSearchHit(new SearchSource(ESearchTokenSourceType.PATH, suggestion.title()), suggestion.project())));
        }
        Collections.sort(this.searchHits);
        this.numberOfHits = this.searchHits.size();
        int maxPage = Math.max(1, (int)Math.ceil((double)this.numberOfHits / (double)Math.max(limitPerPage, 1)));
        this.currentPage = Math.max(1, page);
        this.currentPage = Math.min(this.currentPage, maxPage);
        List<SearchResult> searchResultsForCurrentPage = this.collectSearchResultsForCurrentPage(limitPerPage, this.numberOfHits);
        return new SearchResultContainer(searchResultsForCurrentPage, this.buildCodeSearchTreemapForResults(searchQuery, sources, treemapRequestOptions, path), this.numberOfHits, this.currentPage, maxPage);
    }

    private Set<String> getIncludedArchitectureFiles(UniformPath path) throws StorageException {
        if (!path.isArchitecturePath()) {
            return CollectionUtils.emptySet();
        }
        return ArchitectureMetricsUtils.getArchitectureFreeSourcePaths((String)path.toString(), (ProjectStorageSystem)this.getProjectStorageSystem((IProjectId)this.project), (HistoryAccessOption)HistoryAccessOption.readHead((String)SearchService.getDefaultBranchName((ProjectStorageSystem)this.getProjectStorageSystem((IProjectId)this.project))));
    }

    private static boolean shouldFileBeIncludedInSearch(String filePath, Set<String> includedArchitectureFiles, UniformPath path) {
        if (path.isArchitecturePath()) {
            return includedArchitectureFiles.contains(filePath);
        }
        return filePath.startsWith(path.toString());
    }

    private List<SearchResult> collectSearchResultsForCurrentPage(int limitPerPage, int overallHits) throws StorageException {
        ListMap hitsByCategory = new ListMap();
        this.searchHits.forEach(hit -> hitsByCategory.add((Object)hit.getSource().getSourceType(), hit));
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
        int limit = limitPerPage;
        if (limit == 0 || overallHits < limitPerPage) {
            limit = overallHits;
        }
        HashSet<SearchResult> seenResults = new HashSet<SearchResult>();
        for (ESearchTokenSourceType resultType : hitsByCategory.getKeys()) {
            List hitsInCategory = (List)hitsByCategory.getCollection((Object)resultType);
            for (int i = 0; i < limit; ++i) {
                int index = i + (this.currentPage - 1) * limit;
                if (index >= hitsInCategory.size()) continue;
                SearchResult result = ((SearchHitBase)hitsInCategory.get(index)).createSearchResult();
                if (result != null && seenResults.add(result)) {
                    searchResults.add(result);
                    continue;
                }
                --this.numberOfHits;
            }
        }
        return searchResults;
    }

    private void fillSearchHits(SearchQuery query) throws StorageException {
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        for (PublicProjectId projectId : this.getVisibleSearchedProjects()) {
            this.searchInProject(projectId, projectIndex.resolveToInternalId((IProjectId)projectId), query);
        }
    }

    private void searchInProject(PublicProjectId publicProjectId, InternalProjectId internalProjectId, SearchQuery query) throws StorageException {
        CommitResolvingStorageSystem projectStorage = this.getIndexLayer().openProjectStorageSystem((IProjectId)internalProjectId);
        InvertedCodeSearchIndex invertedSearchIndex = (InvertedCodeSearchIndex)projectStorage.openProjectIndex(InvertedCodeSearchIndex.class, null);
        SearchQuery.SearchHitLookupIndices searchHitLookupIndices = this.openSearchHitLookupIndices(publicProjectId, internalProjectId, projectStorage);
        this.searchHits.addAll(query.performSearch(invertedSearchIndex, searchHitLookupIndices));
    }

    private SearchQuery.SearchHitLookupIndices openSearchHitLookupIndices(PublicProjectId publicProjectId, InternalProjectId internalProjectId, CommitResolvingStorageSystem projectStorage) throws StorageException {
        TokenElementIndex tokenElementIndex = (TokenElementIndex)projectStorage.openProjectIndex(TokenElementIndex.class, "content", HistoryAccessOption.readHead((String)SearchService.getDefaultBranchName((ProjectStorageSystem)projectStorage)));
        IssueIndex issueIndex = (IssueIndex)projectStorage.openProjectIndex(IssueIndex.class, null);
        RepositoryLogIndex logIndex = (RepositoryLogIndex)projectStorage.openProjectIndex(RepositoryLogIndex.class, null);
        Map<String, SpecItemIndex> specItemIndices = this.openSpecItemIndices(internalProjectId, projectStorage);
        return new SearchQuery.SearchHitLookupIndices(publicProjectId, tokenElementIndex, issueIndex, specItemIndices, logIndex, LogEntryResolver.of(this.getGlobalStorageSystem(), projectStorage, publicProjectId, this.getIndexLayer()), this.getPrivacyFilter());
    }

    private BiPredicate<IProjectId, IRepositoryLogEntry> getPrivacyFilter() throws StorageException {
        return new CommitSearchFilter(this.getGlobalStorageSystem(), this.getUser().getUsername(), this.getPermissions());
    }

    private Map<String, SpecItemIndex> openSpecItemIndices(InternalProjectId internalProjectId, CommitResolvingStorageSystem projectStorage) throws StorageException {
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((IProjectId)internalProjectId, (IndexLayer)this.getIndexLayer());
        HashMap<String, SpecItemIndex> specItemIndices = new HashMap<String, SpecItemIndex>();
        for (String requirementManagementConnectorId : SpecItemIndex.getRequirementManagementConnectorIds((ProjectConfiguration)projectConfiguration)) {
            SpecItemIndex index = (SpecItemIndex)projectStorage.openProjectIndex(SpecItemIndex.class, HistoryAccessOption.readHead((String)SpecItemIndex.matchRequirementsManagementConnectorIdToBranchName((String)requirementManagementConnectorId)));
            specItemIndices.put(requirementManagementConnectorId, index);
        }
        String defaultBranchName = this.getDefaultBranchName((IProjectId)internalProjectId);
        SpecItemIndex codeSpecItemIndex = (SpecItemIndex)projectStorage.openProjectIndex(SpecItemIndex.class, HistoryAccessOption.readHead((String)defaultBranchName));
        for (ConnectorConfiguration repositoryConnector : projectConfiguration.getConnectorsByNames((Set)ERepositoryConnector.getReadableNames())) {
            specItemIndices.put(repositoryConnector.getIdentifier(), codeSpecItemIndex);
        }
        return specItemIndices;
    }
}

