/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.simulink;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.SimulinkModelInfoIndex;
import com.teamscale.index.simulink.subsystems.SimulinkFileReferenceIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import eu.cqse.check.simulink.simulink.phases.ReferencedItem;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReference;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.jetbrains.annotations.VisibleForTesting;

@Path(value="api/projects/{project}/simulink/file-references/{uniformPath: .*}")
public class SimulinkFileReferenceService
extends ApiBase {
    public static final String QUALIFIED_NAME_PARAMETER_NAME = "qualifiedName";
    @VisibleForTesting
    private static final String QUALIFIED_NAME_PARAMETER_DESCRIPTION = "The qualified name of the relevant Simulink block of the reference. For subsystem or model references, this is the source block. For library block references, this is the target block.";
    public static final String INVERSE_PARAMETER_NAME = "inverse";
    @VisibleForTesting
    private static final String INVERSE_PARAMETER_DESCRIPTION = "If this is set to true, the inverse references for the file identified by the uniform path are returned.";

    @GET
    @Operation(summary="Get Simulink file references", description="Returns a list of Simulink file references for a source element.", tags={"Simulink"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<SimulinkFileReferenceDependency> getSimulinkFileReferenceDependencies(@PathParam(value="uniformPath") UniformPath uniformPath, @Parameter(description="The qualified name of the relevant Simulink block of the reference. For subsystem or model references, this is the source block. For library block references, this is the target block.") @QueryParam(value="qualifiedName") String qualifiedName, @Parameter(description="If this is set to true, the inverse references for the file identified by the uniform path are returned.") @QueryParam(value="inverse") boolean inverse, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        SimulinkFileReferenceIndex fileReferenceIndex = this.openProjectIndex(SimulinkFileReferenceIndex.class, historyAccessOption);
        SimulinkModelInfoIndex simulinkModelInfoIndex = this.openProjectIndex(SimulinkModelInfoIndex.class, historyAccessOption);
        List<SimulinkFileReference> simulinkFileReferences = inverse ? this.getInverseSimulinkFileReferences(fileReferenceIndex, uniformPath, qualifiedName) : this.getSimulinkFileReferences(fileReferenceIndex, uniformPath, qualifiedName);
        return this.transformToDependencies(simulinkFileReferences, simulinkModelInfoIndex);
    }

    private List<SimulinkFileReferenceDependency> transformToDependencies(List<SimulinkFileReference> simulinkFileReferences, SimulinkModelInfoIndex simulinkModelInfoIndex) throws StorageException {
        ArrayList<SimulinkFileReferenceDependency> simulinkFileReferenceDependencies = new ArrayList<SimulinkFileReferenceDependency>();
        for (SimulinkFileReference reference : simulinkFileReferences) {
            String simpleFilename = this.getSimpleFileName(reference);
            String relevantQualifiedName = this.getQualifiedName(reference.getReferenceItem());
            List uniformPaths = simulinkModelInfoIndex.getUniformPathsWithSimpleFileName(simpleFilename);
            uniformPaths.forEach(path -> simulinkFileReferenceDependencies.add(new SimulinkFileReferenceDependency(reference.getReferenceItem().getType().getDisplayName(), reference.getUniformPath(), reference.getSourceBlockQualifiedName(), (String)path, relevantQualifiedName)));
        }
        return simulinkFileReferenceDependencies;
    }

    private String getSimpleFileName(SimulinkFileReference reference) {
        return switch (reference.getReferenceItem().getType()) {
            case ReferencedItem.EReferencedItemType.BLOCK_IN_LIBRARY -> StringUtils.getFirstPart((String)reference.getReferenceItem().getTarget(), (char)'/');
            case ReferencedItem.EReferencedItemType.MODEL_FILE -> reference.getReferenceItem().getTarget();
            default -> null;
        };
    }

    private String getQualifiedName(ReferencedItem referencedItem) {
        if (ReferencedItem.EReferencedItemType.BLOCK_IN_LIBRARY.equals((Object)referencedItem.getType())) {
            return referencedItem.getTarget();
        }
        return null;
    }

    private List<SimulinkFileReference> getSimulinkFileReferences(SimulinkFileReferenceIndex fileReferenceIndex, UniformPath uniformPath, String qualifiedName) throws StorageException {
        return fileReferenceIndex.getFileReferences(uniformPath.toString()).stream().filter(fileReference -> SimulinkFileReferenceService.isMatchingReferencedBlockWithSourceBlock(fileReference, qualifiedName)).toList();
    }

    private List<SimulinkFileReference> getInverseSimulinkFileReferences(SimulinkFileReferenceIndex fileReferenceIndex, UniformPath uniformPath, String qualifiedName) throws StorageException {
        return fileReferenceIndex.getAllFileReferences().stream().filter(fileReference -> SimulinkFileReferenceService.isMatchingSubsystemReference(fileReference, uniformPath.toString()) || SimulinkFileReferenceService.isMatchingLibraryBlockReference(fileReference, qualifiedName)).toList();
    }

    private static boolean isMatchingSubsystemReference(SimulinkFileReference fileReference, String uniformPath) {
        String subsystemFileName = SimulinkUtils.extractSimpleFileName((String)uniformPath);
        return fileReference.hasTargetWithType(ReferencedItem.EReferencedItemType.MODEL_FILE) && fileReference.hasTargetWithName(subsystemFileName);
    }

    private static boolean isMatchingLibraryBlockReference(SimulinkFileReference fileReference, String blockQualifiedName) {
        return fileReference.hasTargetWithType(ReferencedItem.EReferencedItemType.BLOCK_IN_LIBRARY) && fileReference.hasTargetWithName(blockQualifiedName);
    }

    private static boolean isMatchingReferencedBlockWithSourceBlock(SimulinkFileReference fileReference, String blockQualifiedName) {
        return (fileReference.hasTargetWithType(ReferencedItem.EReferencedItemType.MODEL_FILE) || fileReference.hasTargetWithType(ReferencedItem.EReferencedItemType.BLOCK_IN_LIBRARY)) && fileReference.hasSourceWithParentBlockName(blockQualifiedName);
    }

    public static class SimulinkFileReferenceDependency {
        private static final String REFERENCE_TYPE_NAME_PROPERTY = "referenceTypeName";
        private static final String SOURCE_MODEL_UNIFORM_PATH_PROPERTY = "sourceModelUniformPath";
        private static final String SOURCE_BLOCK_QUALIFIED_NAME_PROPERTY = "sourceBlockQualifiedName";
        private static final String TARGET_MODEL_UNIFORM_PATH_PROPERTY = "targetModelUniformPath";
        private static final String TARGET_BLOCK_QUALIFIED_NAME_PROPERTY = "targetBlockQualifiedName";
        @JsonProperty(value="referenceTypeName")
        private final String referenceTypeName;
        @JsonProperty(value="sourceModelUniformPath")
        private final String sourceModelUniformPath;
        @JsonProperty(value="sourceBlockQualifiedName")
        private final String sourceBlockQualifiedName;
        @JsonProperty(value="targetModelUniformPath")
        private final String targetModelUniformPath;
        @JsonProperty(value="targetBlockQualifiedName")
        private final @Nullable String targetBlockQualifiedName;

        @JsonCreator
        public SimulinkFileReferenceDependency(@JsonProperty(value="referenceTypeName") String referenceTypeName, @JsonProperty(value="sourceModelUniformPath") String sourceModelUniformPath, @JsonProperty(value="sourceBlockQualifiedName") String sourceBlockQualifiedName, @JsonProperty(value="targetModelUniformPath") String targetModelUniformPath, @JsonProperty(value="targetBlockQualifiedName") @Nullable String targetBlockQualifiedName) {
            this.referenceTypeName = referenceTypeName;
            this.sourceModelUniformPath = sourceModelUniformPath;
            this.sourceBlockQualifiedName = sourceBlockQualifiedName;
            this.targetModelUniformPath = targetModelUniformPath;
            this.targetBlockQualifiedName = targetBlockQualifiedName;
        }

        public String toString() {
            String result = this.referenceTypeName + ": " + this.sourceModelUniformPath + "(" + this.sourceBlockQualifiedName + ") -> " + this.targetModelUniformPath;
            if (this.targetBlockQualifiedName != null) {
                result = result + "(" + this.targetBlockQualifiedName + ")";
            }
            return result;
        }
    }
}

