/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.tasks;

import com.teamscale.index.task.ETaskStatus;
import com.teamscale.service.base.ESortOrder;
import com.teamscale.service.tasks.ETaskSortProperty;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TaskServiceQueryOptions {
    private static final String IDS_PARAMETER_NAME = "ids";
    protected static final String ASSIGNEE_PARAMETER_NAME = "assignee";
    protected static final String AUTHOR_PARAMETER_NAME = "author";
    @QueryParam(value="sort-by")
    @DefaultValue(value="ID")
    @Parameter(description="Specifies the field to sort tasks by.")
    private ETaskSortProperty sortBy;
    @QueryParam(value="ids")
    @Parameter(description="Task IDs filter")
    private List<Integer> ids;
    @QueryParam(value="status")
    @Parameter(description="Task status filter")
    private List<ETaskStatus> statuses;
    @QueryParam(value="tag")
    @Parameter(description="Task tag filter")
    private List<String> tags;
    @QueryParam(value="assignee")
    @Parameter(description="Task assignee filter")
    private List<String> assignees;
    @QueryParam(value="author")
    @Parameter(description="Task author filter")
    private List<String> authors;
    @QueryParam(value="sort-order")
    @DefaultValue(value="ASCENDING")
    @Parameter(description="Specifies the sort order of requested tasks. One of ascending or descending")
    private ESortOrder sortOrder;
    @QueryParam(value="max")
    @Parameter(description="Limits the number of tasks returned to the given number. 0 means that all results should be returned.")
    private int maxResultCount;
    @QueryParam(value="start")
    @Parameter(description="Specifies start index of requested tasks.The tasks returned will start from this index (0 based).")
    private int startIndex;
    @QueryParam(value="details")
    @DefaultValue(value="false")
    @Parameter(description="Defines whether details (list of findings, discussion history) are retrieved. This can be used to reduce the amount of data transferred when retrieving all tasks.)")
    private boolean details;
    @QueryParam(value="branch")
    @Parameter(description="Optional: The branch for which to determine the findings' removal status")
    private @Nullable String branch;

    public ETaskSortProperty getSortBy() {
        return this.sortBy;
    }

    public List<Integer> getIds() {
        return this.ids;
    }

    public List<ETaskStatus> getStatuses() {
        return this.statuses;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<String> getAssignees() {
        return this.assignees;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public ESortOrder getSortOrder() {
        return this.sortOrder;
    }

    public int getMaxResultCount() {
        return this.maxResultCount;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public boolean isDetailsRequested() {
        return this.details;
    }

    public String getBranchName() {
        return this.branch;
    }
}

