/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.tasks;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.task.Task;
import com.teamscale.index.task.TaskIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.dto.PreviousNextSiblings;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.tasks.TaskServiceFilterUtils;
import com.teamscale.service.tasks.TaskServiceQueryOptions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.store.StorageException;
import org.jetbrains.annotations.VisibleForTesting;

@Path(value="api/projects/{project}/tasks/{task}/siblings")
public class TaskSiblingsService
extends ApiBase {
    @GET
    @Operation(summary="Get task siblings", description="Retrieves the task siblings (previous and next tasks) for the task specified by ID, allowing user filters.", tags={"Tasks"}, responses={@ApiResponse(responseCode="404", description="Task with provided ID could not be found.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public PreviousNextSiblings getTaskPreviousNext(@BeanParam TaskServiceQueryOptions parameters, @Parameter(description="ID of the task to retrieve the sibling tasks for.") @PathParam(value="task") int taskId) throws StorageException {
        TaskIndex taskIndex = this.openProjectIndex(TaskIndex.class, null);
        Task task = TaskServiceFilterUtils.retrieveTask(taskIndex, taskId);
        List<Task> tasks = taskIndex.getAllTasks();
        tasks = TaskServiceFilterUtils.applyFiltersAndSort(parameters, tasks);
        return TaskSiblingsService.searchSiblingTasks(tasks, task.getId());
    }

    @VisibleForTesting
    public static PreviousNextSiblings searchSiblingTasks(List<Task> tasks, int taskId) {
        Task current;
        int idx;
        Task previous = null;
        Task next = null;
        for (idx = 0; idx < tasks.size() && (current = tasks.get(idx)).getId() != taskId; ++idx) {
            previous = current;
        }
        if (idx == tasks.size()) {
            return new PreviousNextSiblings(null, null);
        }
        if (idx + 1 < tasks.size()) {
            next = tasks.get(idx + 1);
        }
        return TaskSiblingsService.createPreviousNextSiblings(previous, next);
    }

    private static @NonNull PreviousNextSiblings createPreviousNextSiblings(Task previous, Task next) {
        PreviousNextSiblings neighboringTasks = new PreviousNextSiblings(null, null);
        if (previous != null && next != null) {
            neighboringTasks = new PreviousNextSiblings(Integer.toString(previous.getId()), Integer.toString(next.getId()));
        } else if (previous != null) {
            neighboringTasks = new PreviousNextSiblings(Integer.toString(previous.getId()), null);
        } else if (next != null) {
            neighboringTasks = new PreviousNextSiblings(null, Integer.toString(next.getId()));
        }
        return neighboringTasks;
    }
}

