/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.issues.WorkItemHistoryIndexAggregation;
import com.teamscale.index.query.QueryableEntityUtils;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndexCache;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.assessment.TgaAggregationUtils;
import com.teamscale.index.testgap.query.CoverageSourceParameterBase;
import com.teamscale.index.testgap.query.CoverageSourceQueryParameters;
import com.teamscale.index.testgap.query.IssueTgaParameters;
import com.teamscale.index.testgap.query.TgaIssueRequest;
import com.teamscale.index.testgap.query.TgaRequestAssessmentQueryOptions;
import com.teamscale.index.testgap.query.TgaRequestUtils;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.issues.IssueContributor;
import com.teamscale.service.testgap.CrossAnnotationServiceBase;
import com.teamscale.service.testgap.TgaSummary;
import com.teamscale.wia.TeamscaleIssueId;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectIndex;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CounterSet;

@Path(value="api/projects/{project}/issue-query/tga-summary")
public class IssueQueryTgaSummaryService
extends CrossAnnotationServiceBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get Issue Query TGA Summary", description="Retrieves the TGA summary for a set of issues matched by the given query.", responses={@ApiResponse(responseCode="400", description="Could not process provided query")}, tags={"Test Gap Analysis", "Issues"})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class, IssueContributor.IssuesLastUpdatedContributor.class})
    public TgaSummary getIssueQueryTgaSummary(@Parameter(description="The issue query", required=true, allowEmptyValue=true) @QueryParam(value="query") String query, @BeanParam IssueTgaParameters issueTgaParameters, @BeanParam CoverageSourceQueryParameters coverageSourceParameters, @BeanParam TgaRequestAssessmentQueryOptions assessmentOptions) throws StorageException {
        this.checkCrossAnnotationPermissions((CoverageSourceParameterBase)coverageSourceParameters);
        ETgaAssessmentType assessmentType = assessmentOptions.getAssessmentType();
        Collection<AssessedTgaData> dataPerIssue = IssueQueryTgaSummaryService.processIssueQuery(this.serviceInfo, query, (CoverageSourceParameterBase)coverageSourceParameters, issueTgaParameters, assessmentType);
        CounterSet totalStateCount = new CounterSet();
        dataPerIssue.forEach(assessedData -> totalStateCount.add(TgaAggregationUtils.countStates((AssessedTgaData)assessedData)));
        return new TgaSummary(assessmentType, (CounterSet<ETestGapState>)totalStateCount);
    }

    private static Collection<AssessedTgaData> processIssueQuery(ITeamscaleServiceInfo serviceInfo, String issueQuery, CoverageSourceParameterBase coverageSourceParameters, IssueTgaParameters issueTgaParameters, ETgaAssessmentType assessmentType) throws StorageException {
        List<TeamscaleIssueId> issueIds;
        String branch = TgaIssueRequest.determineIssueBranch((IssueTgaParameters)issueTgaParameters, null, (CommitResolvingStorageSystem)serviceInfo.getProjectStorageSystem());
        WorkItemHistoryIndexAggregation indexAggregation = WorkItemHistoryIndexAggregation.forIssues((ProjectStorageSystem)serviceInfo.getProjectStorageSystem(), (HistoryAccessOption)HistoryAccessOption.readHead((String)branch));
        CommitResolvingStorageSystem projectStorageSystem = serviceInfo.getProjectStorageSystem();
        QueryableEntityUtils.QueryContext queryContext = QueryableEntityUtils.QueryContext.ofTimestamp((ProjectStorageSystem)projectStorageSystem, (GlobalStorageSystem)serviceInfo.getGlobalStorageSystem(), (User)serviceInfo.getUser(), (StoredQueryIndex.EStoredQueryType)StoredQueryIndex.EStoredQueryType.ISSUE, (long)System.currentTimeMillis(), (String)branch);
        try {
            issueIds = QueryableEntityUtils.performQueryWithEmptyHandling((String)issueQuery, (IKeyedObjectIndex)indexAggregation, (QueryableEntityUtils.QueryContext)queryContext).stream().map(TeamscaleIssueId::fromInternalId).toList();
        }
        catch (QueryCompilationException | QueryParsingException e) {
            throw new BadRequestException("Could not process query: " + e.getMessage(), e);
        }
        return IssueQueryTgaSummaryService.getAssessedTgaData(issueIds, serviceInfo, coverageSourceParameters, issueTgaParameters, assessmentType);
    }

    private static Collection<AssessedTgaData> getAssessedTgaData(List<TeamscaleIssueId> issueIds, ITeamscaleServiceInfo serviceInfo, CoverageSourceParameterBase coverageSourceParameters, IssueTgaParameters issueTgaParameters, ETgaAssessmentType assessmentType) throws StorageException {
        RepositoryCommitIssueMappingIndexCache mappingIndexCache = TgaRequestUtils.createAndPreloadIssueMappingCache(issueIds, (CommitResolvingStorageSystem)serviceInfo.getProjectStorageSystem());
        ArrayList<AssessedTgaData> data = new ArrayList<AssessedTgaData>();
        for (TeamscaleIssueId issueId : issueIds) {
            TgaIssueRequest request = TgaIssueRequest.createRequest((TeamscaleIssueId)issueId, (CoverageSourceParameterBase)coverageSourceParameters, (IssueTgaParameters)issueTgaParameters, (ETgaAssessmentType)assessmentType, (RepositoryCommitIssueMappingIndexCache)mappingIndexCache, (IndexLayer)serviceInfo.getIndexLayer(), (IProjectId)serviceInfo.getPrimaryPublicId());
            AssessedTgaData assessedData = request.fetchAndAssessData();
            data.add(assessedData);
        }
        return data;
    }
}

