/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.external.update.ExternalResultsPartitionLastUpdateIndex;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testgap.CoverageSourceInfo;
import com.teamscale.index.testgap.MethodLastTestedIndex;
import com.teamscale.index.testgap.query.CoverageSourceParameterBase;
import com.teamscale.index.testgap.query.CoverageSourceQueryParameters;
import com.teamscale.index.testgap.query.TgaRequestUtils;
import com.teamscale.index.testgap.trend.TestCoverageDeltaIndex;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.testgap.CrossAnnotationServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.jetbrains.annotations.VisibleForTesting;

@Path(value="api/projects/{project}/test-gaps/overview")
public class TgaOverviewService
extends CrossAnnotationServiceBase {
    @GET
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    @Operation(summary="Get coverage sources", description="Retrieves information about coverage sources (partitions and cross-annotation projects),  respecting the given path.", tags={"Test Gap Analysis"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<CoverageSourceInfo> getCoverageSources(@BeanParam CoverageSourceQueryParameters coverageSourceParameters, @BeanParam TimeIntervalBasedServiceQueryOptions timeIntervalParameters) throws StorageException {
        this.checkCrossAnnotationPermissions((CoverageSourceParameterBase)coverageSourceParameters);
        long baselineTimestamp = timeIntervalParameters.resolveBaselineCommit(() -> this.getProjectStorageSystem()).getTimestamp();
        CommitDescriptor endCommit = timeIntervalParameters.resolveEndCommit(() -> this.getProjectStorageSystem());
        ArrayList<CoverageSourceInfo> resultList = new ArrayList<CoverageSourceInfo>();
        resultList.addAll(this.getCurrentProjectCoverageSources(baselineTimestamp, endCommit, (CoverageSourceParameterBase)coverageSourceParameters));
        resultList.addAll(this.getCrossAnnotatedCoverageSources(baselineTimestamp, endCommit, (CoverageSourceParameterBase)coverageSourceParameters));
        return resultList;
    }

    private List<CoverageSourceInfo> getCurrentProjectCoverageSources(long baselineTimestamp, CommitDescriptor endCommit, CoverageSourceParameterBase coverageParameters) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)endCommit);
        TestCoverageDeltaIndex testCoverageDeltaIndex = this.openProjectIndex(TestCoverageDeltaIndex.class, null);
        ExternalResultsPartitionLastUpdateIndex lastUpdateIndex = this.openProjectIndex(ExternalResultsPartitionLastUpdateIndex.class, historyAccessOption);
        ArrayList<CoverageSourceInfo> resultList = new ArrayList<CoverageSourceInfo>();
        MethodLastTestedIndex methodLastTestedIndex = this.openProjectIndex(MethodLastTestedIndex.class, historyAccessOption);
        List partitions = coverageParameters.getPartitions((Collection)methodLastTestedIndex.getPartitions());
        Map<String, TestCoverageDeltaIndex.CoverageUploadTimeRange> timeRangePerPartition = TgaOverviewService.loadUploadTimeRangePerPartition(baselineTimestamp, endCommit, partitions, testCoverageDeltaIndex, lastUpdateIndex);
        for (Map.Entry timeRangeInPartition : CollectionUtils.sort(timeRangePerPartition.entrySet(), Map.Entry.comparingByKey())) {
            resultList.add(this.createCoverageSourceInfo(endCommit, (TestCoverageDeltaIndex.CoverageUploadTimeRange)timeRangeInPartition.getValue(), (String)timeRangeInPartition.getKey(), false));
        }
        return resultList;
    }

    private List<CoverageSourceInfo> getCrossAnnotatedCoverageSources(long baselineTimestamp, CommitDescriptor endCommit, CoverageSourceParameterBase coverageParameters) throws StorageException {
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        Set crossAnnotationProjects = coverageParameters.getCrossAnnotationProjects(projectIndex);
        ITeamscaleServiceInfo serviceInfo = this.serviceInfo;
        PairList crossAnnotationIndexes = TgaRequestUtils.getCrossAnnotationIndexes((Collection)crossAnnotationProjects, TestCoverageDeltaIndex.class, (IndexLayer)serviceInfo.getIndexLayer());
        ArrayList<CoverageSourceInfo> resultList = new ArrayList<CoverageSourceInfo>();
        for (int i = 0; i < crossAnnotationIndexes.size(); ++i) {
            TestCoverageDeltaIndex index = (TestCoverageDeltaIndex)crossAnnotationIndexes.getSecond(i);
            resultList.add(this.createCoverageSourceInfo(endCommit, index.getCoverageUploadTimeRangesForAllPartitions(baselineTimestamp, endCommit.getTimestamp()), ((PublicProjectId)crossAnnotationIndexes.getFirst(i)).toString(), true));
        }
        return resultList;
    }

    @VisibleForTesting
    public static Map<String, TestCoverageDeltaIndex.CoverageUploadTimeRange> loadUploadTimeRangePerPartition(long queryStartTimestamp, CommitDescriptor queryEndCommit, List<String> coveragePartitions, TestCoverageDeltaIndex testCoverageDeltaIndex, ExternalResultsPartitionLastUpdateIndex externalResultsPartitionLastUpdateIndex) throws StorageException {
        Map timeRangeByPartition = testCoverageDeltaIndex.getCoverageUploadTimeRangesByPartition(queryStartTimestamp, queryEndCommit.getTimestamp(), coveragePartitions);
        Map<String, Long> newestUploadTimestampByPartition = TgaOverviewService.loadNewestUploadsByPartition(coveragePartitions, externalResultsPartitionLastUpdateIndex);
        HashMap<String, TestCoverageDeltaIndex.CoverageUploadTimeRange> uploadTimeRangeByPartition = new HashMap<String, TestCoverageDeltaIndex.CoverageUploadTimeRange>();
        for (String currentPartition : coveragePartitions) {
            TestCoverageDeltaIndex.CoverageUploadTimeRange partitionTimeRange = (TestCoverageDeltaIndex.CoverageUploadTimeRange)timeRangeByPartition.get(currentPartition);
            Optional<Long> newestUploadTimestamp = Optional.ofNullable(newestUploadTimestampByPartition.get(currentPartition));
            if (newestUploadTimestamp.isPresent() && TgaOverviewService.isBetween(queryStartTimestamp, newestUploadTimestamp.get(), queryEndCommit.getTimestamp())) {
                partitionTimeRange.addCoverageUploadTimestamp(newestUploadTimestampByPartition.get(currentPartition).longValue());
            }
            uploadTimeRangeByPartition.put(currentPartition, partitionTimeRange);
        }
        return uploadTimeRangeByPartition;
    }

    private static boolean isBetween(long lowerBound, long between, long upperBound) {
        return lowerBound <= between && between <= upperBound;
    }

    private static Map<String, Long> loadNewestUploadsByPartition(List<String> partitions, ExternalResultsPartitionLastUpdateIndex externalResultsPartitionLastUpdateIndex) throws StorageException {
        Map partitionToLastUpdateMap = externalResultsPartitionLastUpdateIndex.getPartitionToLastUpdateMap();
        HashMap<String, Long> lastTimestampPerPartition = new HashMap<String, Long>();
        for (Map.Entry lastCommitPerPartition : partitionToLastUpdateMap.entrySet()) {
            if (!partitions.contains(lastCommitPerPartition.getKey())) continue;
            lastTimestampPerPartition.put((String)lastCommitPerPartition.getKey(), ((CommitDescriptor)lastCommitPerPartition.getValue()).getTimestamp());
        }
        return lastTimestampPerPartition;
    }

    private CoverageSourceInfo createCoverageSourceInfo(CommitDescriptor endCommit, TestCoverageDeltaIndex.CoverageUploadTimeRange currentSummaryStatistics, String partition, boolean isCrossAnnotationProject) throws StorageException {
        RepositoryLogIndex logIndex = this.openProjectIndex(RepositoryLogIndex.class, null);
        long firstTimestamp = currentSummaryStatistics.getOldestUploadTimestamp();
        long lastTimestamp = currentSummaryStatistics.getNewestUploadTimestamp();
        String firstMessage = "";
        String lastMessage = "";
        if (!currentSummaryStatistics.hasNoCoverageUpload()) {
            RepositoryLogEntryAggregate logEntryFirst = (RepositoryLogEntryAggregate)logIndex.getEntry(new CommitDescriptor(endCommit.getBranchName(), firstTimestamp));
            firstMessage = TgaOverviewService.determineCoverageMessage(logEntryFirst, isCrossAnnotationProject);
            RepositoryLogEntryAggregate logEntryLast = (RepositoryLogEntryAggregate)logIndex.getEntry(new CommitDescriptor(endCommit.getBranchName(), lastTimestamp));
            lastMessage = TgaOverviewService.determineCoverageMessage(logEntryLast, isCrossAnnotationProject);
        }
        return new CoverageSourceInfo(partition, firstTimestamp, lastTimestamp, isCrossAnnotationProject, firstMessage, lastMessage);
    }

    private static String determineCoverageMessage(RepositoryLogEntryAggregate logEntry, boolean isCrossAnnotationProject) {
        if (isCrossAnnotationProject) {
            return "Upload for other project";
        }
        if (logEntry == null) {
            return "Upload to other branch";
        }
        return logEntry.getMessage();
    }
}

