/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap.trend;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testgap.query.CoverageSourceParameterBase;
import com.teamscale.index.testgap.query.CoverageSourceQueryParameters;
import com.teamscale.index.testgap.query.TgaRequestAssessmentQueryOptions;
import com.teamscale.index.testgap.query.TgaRequestQueryOptions;
import com.teamscale.index.testgap.trend.TgaTrendComputer;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.metrics.history.MetricTrendEntry;
import com.teamscale.service.testgap.CrossAnnotationServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/projects/{project}/test-gaps/trend")
public class TgaTrendService
extends CrossAnnotationServiceBase {
    @GET
    @Cache(maxAge=5, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    @Operation(summary="Get test gap trend", description="Calculates test gap trends. Does not support issue requests.", responses={@ApiResponse(responseCode="400", description="Attempt to use timespan to retrieve execution treemap of a single test run. Baseline timestamp and end timestamp have to be equal."), @ApiResponse(responseCode="404", description="Found no commits to be merged."), @ApiResponse(responseCode="400", description="Could not determine common merge base.")}, tags={"Test Gap Analysis"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<MetricTrendEntry> getTgaTrend(@BeanParam TimeIntervalBasedServiceQueryOptions timeIntervalParameters, @BeanParam TgaRequestQueryOptions tgaRequestParameters, @BeanParam CoverageSourceQueryParameters coverageSourceParameters, @BeanParam TgaRequestAssessmentQueryOptions assessmentQueryOptions) throws StorageException {
        this.checkCrossAnnotationPermissions((CoverageSourceParameterBase)coverageSourceParameters);
        List tgaTrendEntries = new TgaTrendComputer(this.serviceInfo.getIndexLayer(), (IProjectId)this.serviceInfo.getPrimaryPublicId(), this.serviceInfo.getProjectStorageSystem()).processTgaTrendRequest(timeIntervalParameters, tgaRequestParameters, (CoverageSourceParameterBase)coverageSourceParameters, assessmentQueryOptions.getAssessmentType());
        return CollectionUtils.map((Collection)tgaTrendEntries, tgaTrendEntry -> new MetricTrendEntry(tgaTrendEntry.timestamp(), tgaTrendEntry.counts().values().toArray(Object[]::new)));
    }
}

