/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.index.resource.VirtualCodePathUtils;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.testimpact.ExecutionUnitIndex;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.index.tests.TestExecutionWithPartition;
import com.teamscale.service.testimpact.prioritization.PrioritizableTest;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.sourcecode.coverage.ExecutionUnit;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class TestDataRetriever {
    private final ExecutionUnitIndex executionUnitIndex;
    private final TestExecutionIndex testExecutionIndex;
    private final CoverageUnitToMethodsMapIndex testsToMethodsMapIndex;
    private final ProjectStorageSystem projectStorageSystem;
    private final HistoryAccessOption historyAccessOption;
    private final @Nullable UniformPath coveringPath;

    public TestDataRetriever(CommitResolvingStorageSystem projectStorageSystem, CommitDescriptor commit) throws StorageException {
        this(projectStorageSystem, commit, null);
    }

    public TestDataRetriever(CommitResolvingStorageSystem projectStorageSystem, CommitDescriptor commit, @Nullable UniformPath coveringPath) throws StorageException {
        this.historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)commit);
        this.projectStorageSystem = projectStorageSystem;
        this.coveringPath = coveringPath;
        this.executionUnitIndex = (ExecutionUnitIndex)projectStorageSystem.openProjectIndex(ExecutionUnitIndex.class, this.historyAccessOption);
        this.testExecutionIndex = (TestExecutionIndex)projectStorageSystem.openProjectIndex(TestExecutionIndex.class, this.historyAccessOption);
        this.testsToMethodsMapIndex = (CoverageUnitToMethodsMapIndex)projectStorageSystem.openProjectIndex(CoverageUnitToMethodsMapIndex.class, this.historyAccessOption);
    }

    public Collection<Set<MethodId>> getCoveredMethodsPerTest(List<PrioritizableTest> testSet) throws StorageException {
        List relevantPartitionAndTests = CollectionUtils.map(testSet, TestDataRetriever::createPartitionAndTest);
        Predicate pathContainmentChecker = VirtualCodePathUtils.includedInResolvedTree((UniformPath)this.coveringPath, (ProjectStorageSystem)this.projectStorageSystem, (HistoryAccessOption)this.historyAccessOption);
        return this.testsToMethodsMapIndex.getMethodsCoveredBy(relevantPartitionAndTests).stream().map(set -> set.stream().filter(method -> pathContainmentChecker.test(method.getUniformPath())).collect(Collectors.toSet())).toList();
    }

    private static PartitionAndPath createPartitionAndTest(PrioritizableTest test) {
        return PartitionAndPath.forCoverageUnit((String)test.getPartition(), (String)test.getUniformPathString());
    }

    public List<TestExecutionWithPartition> getTestExecutions(List<PartitionAndPath> executableUnitsOrTests) throws StorageException {
        return this.testExecutionIndex.getTestExecutionsForPartitionAndPaths(executableUnitsOrTests);
    }

    public List<ExecutionUnit> getExecutionUnits(List<PartitionAndPath> executableUnitsOrTests) throws StorageException {
        return this.executionUnitIndex.getExecutionUnits(executableUnitsOrTests);
    }
}

