/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.teamscale.index.testimpact.ExecutionUnitIndex;
import com.teamscale.index.testimpact.PrioritizedTestListIndex;
import com.teamscale.index.testimpact.SelectedTest;
import com.teamscale.index.testimpact.TestMinimizationJobRun;
import com.teamscale.index.testimpact.TestMinimizationJobsIndex;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.index.tests.TestExecutionWithPartition;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.ExecutionUnit;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class TestSelectionStorageUtils {
    static PrioritizedTestListIndex.TestListDeltaSummary appendTests(TestMinimizationJobRun job, TestMinimizationJobsIndex jobsIndex, PrioritizedTestListIndex testMinimizationJobResultIndex, List<SelectedTest> toAppend) throws StorageException {
        PrioritizedTestListIndex.TestListDeltaSummary addResult = testMinimizationJobResultIndex.appendToList(job.getId(), toAppend);
        jobsIndex.setJob(job.getId(), job.withTestCount(addResult.totalTests()).withTestDuration(addResult.totalDurationMs()).withTestListHash(addResult.testListHash()));
        return addResult;
    }

    static PrioritizedTestListIndex.TestListDeltaSummary appendPartitionAndPaths(TestMinimizationJobRun job, TestMinimizationJobsIndex jobsIndex, PrioritizedTestListIndex testMinimizationJobResultIndex, TestExecutionIndex testExecutionIndex, ExecutionUnitIndex executionUnitIndex, List<PartitionAndPath> toAppend) throws StorageException {
        List prioritizablesToAppend = CollectionUtils.mapWithException(toAppend, pp -> {
            TestExecutionWithPartition testExecution;
            List testExecutions;
            ExecutionUnit executionUnit;
            Long durationInMs = null;
            @Nullable List executionUnits = executionUnitIndex.getExecutionUnits(Collections.singletonList(pp));
            if (executionUnits.size() == 1 && (executionUnit = (ExecutionUnit)executionUnits.get(0)) != null && executionUnit.getDurationSeconds() != null) {
                durationInMs = Math.round(executionUnit.getDurationSeconds() * 1000.0);
            }
            if (durationInMs == null && (testExecutions = testExecutionIndex.getTestExecutionsForPartitionAndPaths(Collections.singletonList(pp))).size() == 1 && (testExecution = (TestExecutionWithPartition)testExecutions.get(0)) != null) {
                durationInMs = Math.round(testExecution.getTestExecution().getDurationMillis());
            }
            return SelectedTest.withoutRanking((String)pp.getUniformPath(), (String)pp.getPartition(), (Long)Optional.ofNullable(durationInMs).orElse(0L));
        });
        return TestSelectionStorageUtils.appendTests(job, jobsIndex, testMinimizationJobResultIndex, prioritizablesToAppend);
    }

    private TestSelectionStorageUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

