/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.repository.FirstLastCommit;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.utils.IssueUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.wia.TeamscaleIssueId;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;

@Path(value="api/projects/{project}/test-coverage/testwise/partitions")
public class TestwiseCoveragePartitionsService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get testwise coverage partitions", description="Returns a list of partitions that have testwise coverage in the given project.", tags={"Test Coverage"})
    public List<String> getTestwiseCoveragePartitions(@Parameter(description="ID of the issue to determine the time for which the data should be provided. If this is set, and the timestamp parameter is also defined, the HEAD of the given branch will be used. If the timestamp parameter is not defined, the HEAD of the issue's last commit will be used. This complies with the behavior of auto-selecting the branch of an issue.", schema=@Schema(type="string")) @QueryParam(value="issue-id") TeamscaleIssueId issueId, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        if (issueId != null) {
            if (commit.getBranchName() != null) {
                historyAccessOption = HistoryAccessOption.readHead((String)commit.getBranchName());
            } else {
                Optional firstAndLastCommit = IssueUtils.determineFirstAndLastCommitForIssue((TeamscaleIssueId)issueId, (CommitResolvingStorageSystem)this.serviceInfo.getProjectStorageSystem());
                if (firstAndLastCommit.isPresent() && ((FirstLastCommit)firstAndLastCommit.get()).lastCommit.getBranchName() != null) {
                    historyAccessOption = HistoryAccessOption.readHead((String)((FirstLastCommit)firstAndLastCommit.get()).lastCommit.getBranchName());
                }
            }
        }
        CoverageUnitToMethodsMapIndex coverageIndex = this.openProjectIndex(CoverageUnitToMethodsMapIndex.class, historyAccessOption);
        return coverageIndex.getPartitions();
    }
}

