/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact;

import com.google.common.collect.Iterables;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.user.User;
import com.teamscale.index.merge_request.BranchPointNotFoundException;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.query.CoverageSourceParameterBase;
import com.teamscale.index.testgap.query.CoverageSourceQueryParameters;
import com.teamscale.index.testgap.query.ITgaRequest;
import com.teamscale.index.testgap.query.IssueTgaParameters;
import com.teamscale.index.testgap.query.TgaRequestQueryOptions;
import com.teamscale.index.testimpact.CoverageUnitToMethodsMapIndex;
import com.teamscale.index.testimpact.ETestPrioritizationStrategy;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.index.testimpact.MethodIdIndex;
import com.teamscale.index.testimpact.MethodIdMap;
import com.teamscale.index.testimpact.PartitionedTestSet;
import com.teamscale.index.testimpact.TiaPartitionsQueryParams;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.index.tests.TestExecutionWithPartition;
import com.teamscale.service.testimpact.ImpactedTestUtils;
import com.teamscale.service.testimpact.MinimizationProgressCallback;
import com.teamscale.service.testimpact.TestDataRetriever;
import com.teamscale.service.testimpact.TestPrioritizationData;
import com.teamscale.service.testimpact.TestReductionApiBase;
import com.teamscale.service.testimpact.TestSuggestions;
import com.teamscale.service.testimpact.prioritization.ETestSelectionReason;
import com.teamscale.service.testimpact.prioritization.ITestPrioritizationStrategy;
import com.teamscale.service.testimpact.prioritization.PrioritizableTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.index.shared.tests.ETestExecutionResult;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.uniformpath.UniformPath;

public abstract class TgaBasedTestSuggestionsServiceBase
extends TestReductionApiBase {
    protected TestSuggestions getTestSuggestions(TiaPartitionsQueryParams partitionsQueryParams, IssueTgaParameters issueTgaParameters, TimeIntervalBasedServiceQueryOptions timeIntervalBasedParameters, TgaRequestQueryOptions tgaRequestParameters, boolean includeExecuted) throws RepositoryException, StorageException, BranchPointNotFoundException, InterruptedException {
        ITgaRequest request = ITgaRequest.createRequest((CoverageSourceParameterBase)CoverageSourceQueryParameters.NO_PARTITIONS, (TimeIntervalBasedServiceQueryOptions)timeIntervalBasedParameters, (TgaRequestQueryOptions)tgaRequestParameters, (IssueTgaParameters)issueTgaParameters, (ETgaAssessmentType)ETgaAssessmentType.CHURN, (IndexLayer)this.serviceInfo.getIndexLayer(), (IProjectId)this.serviceInfo.getPrimaryPublicId(), (User)this.serviceInfo.getUser());
        CommitDescriptor commit = request.getIndexAccessCommit();
        if (!this.hasAnyTestwiseCoverage(commit)) {
            return new TestSuggestions(false, commit, List.of(), null);
        }
        List changedMethods = request.fetchAndAssessData().getChangedMethods(false);
        return this.getTestSuggestionsForChanges(changedMethods, partitionsQueryParams, commit, includeExecuted);
    }

    private @NonNull TestSuggestions getTestSuggestionsForChanges(List<AssessedTgaData.AssessedMethodData> changedMethods, TiaPartitionsQueryParams partitionsQueryParams, CommitDescriptor commit, boolean includeExecuted) throws StorageException, InterruptedException {
        List methodLocations = CollectionUtils.map(changedMethods, AssessedTgaData.AssessedMethodData::getLocation);
        List<PrioritizableTest> orderedTests = this.getOrderedTests(changedMethods, partitionsQueryParams, commit, includeExecuted, methodLocations);
        TestSuggestions.TestSuggestionSavings savings = this.computeTestStats(orderedTests, partitionsQueryParams, commit);
        return new TestSuggestions(true, commit, CollectionUtils.map(orderedTests, test -> new TestSuggestions.ImpactedTest(test.getRank(), test.getPartition(), test.getUniformPath(), test.getDurationInMs().orElse(null), (ETestSelectionReason)Iterables.getOnlyElement((Iterable)test.getSelectionReasons()), test.getNumberOfAdditionallyCoveredMethods())), savings);
    }

    private List<PrioritizableTest> getOrderedTests(List<AssessedTgaData.AssessedMethodData> changedMethods, TiaPartitionsQueryParams partitionsQueryParams, CommitDescriptor commit, boolean includeExecuted, List<MethodLocation> methodLocations) throws StorageException, InterruptedException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)commit);
        MethodIdIndex methodIdIndex = this.openProjectIndex(MethodIdIndex.class, historyAccessOption);
        MethodIdMap allMappings = methodIdIndex.getAllMappingsFor(CollectionUtils.map(methodLocations, MethodLocation::getUniformPath));
        Set<MethodId> methodIds = CollectionUtils.map(methodLocations, arg_0 -> ((MethodIdMap)allMappings).getMethodId(arg_0)).stream().filter(Objects::nonNull).collect(Collectors.toSet());
        SetMap<PartitionAndPath, MethodId> testsToMethodsMapping = this.computeTestToMethodsMapping(partitionsQueryParams, methodIds, historyAccessOption);
        Set<PrioritizableTest> prioritizableTests = TgaBasedTestSuggestionsServiceBase.buildPrioritizableTests(testsToMethodsMapping);
        Map<MethodId, Long> methodIdToLastChanged = TgaBasedTestSuggestionsServiceBase.buildMethodLastChangedLookup(changedMethods, allMappings);
        Set<PartitionAndPath> executedTests = this.getExecutedTests(historyAccessOption, testsToMethodsMapping, methodIdToLastChanged);
        if (!includeExecuted) {
            prioritizableTests.removeIf(test -> executedTests.contains(TgaBasedTestSuggestionsServiceBase.getPartitionAndPath(test)));
        }
        return this.orderTests(methodIds, prioritizableTests, commit);
    }

    private static PartitionAndPath getPartitionAndPath(PrioritizableTest test) {
        return new PartitionAndPath(test.getPartition(), test.getUniformPathString());
    }

    private List<PrioritizableTest> orderTests(Set<MethodId> methodIds, Set<PrioritizableTest> prioritizableTests, CommitDescriptor commit) throws StorageException, InterruptedException {
        TestDataRetriever dataRetriever = new TestDataRetriever(this.getProjectStorageSystem(), commit);
        TestPrioritizationData testPrioritizationData = new TestPrioritizationData(prioritizableTests, methodIds, null);
        ITestPrioritizationStrategy prioritizationStrategy = TgaBasedTestSuggestionsServiceBase.initTestPrioritizationStrategy(dataRetriever, testPrioritizationData, MinimizationProgressCallback.dummy(), ETestPrioritizationStrategy.CHEAP_ADDITIONAL_COVERAGE_PER_TIME);
        return prioritizationStrategy.orderTests(prioritizableTests, methodIds, null);
    }

    private static Map<MethodId, Long> buildMethodLastChangedLookup(List<AssessedTgaData.AssessedMethodData> changedMethods, MethodIdMap allMappings) {
        HashMap<MethodId, Long> methodIdToLastChanged = new HashMap<MethodId, Long>();
        for (AssessedTgaData.AssessedMethodData method : changedMethods) {
            MethodLocation methodLocation = method.getLocation();
            methodIdToLastChanged.put(allMappings.getMethodId(methodLocation), method.getLastChangeTimestamp());
        }
        return methodIdToLastChanged;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private Set<PartitionAndPath> getExecutedTests(HistoryAccessOption historyAccessOption, SetMap<PartitionAndPath, MethodId> testsToMethodsMapping, Map<MethodId, Long> methodIdToLastChanged) throws StorageException {
        TestExecutionIndex testExecutionIndex = this.openProjectIndex(TestExecutionIndex.class, historyAccessOption);
        @Nullable List testExecutions = testExecutionIndex.getTestExecutionsForPartitionAndPaths(new ArrayList(testsToMethodsMapping.getKeys()));
        HashSet<PartitionAndPath> executedTests = new HashSet<PartitionAndPath>();
        for (TestExecutionWithPartition execution : testExecutions) {
            if (execution == null || execution.getTestExecution().getResult() != ETestExecutionResult.PASSED) continue;
            long executionTimestamp = execution.getCommit().getTimestamp();
            PartitionAndPath testPartitionAndPath = execution.getPartitionAndPath();
            Set methodsCoveredByTest = (Set)testsToMethodsMapping.getCollection((Object)testPartitionAndPath);
            CCSMAssert.isNotNull((Object)methodsCoveredByTest, (String)("Test " + String.valueOf(testPartitionAndPath) + " has no methods covered by " + String.valueOf(execution.getCommit()) + "!"));
            boolean hasChangedAfterExecution = false;
            for (MethodId methodId : methodsCoveredByTest) {
                if (methodIdToLastChanged.getOrDefault(methodId, 0L) <= executionTimestamp) continue;
                hasChangedAfterExecution = true;
                break;
            }
            if (hasChangedAfterExecution) continue;
            executedTests.add(testPartitionAndPath);
        }
        return executedTests;
    }

    private boolean hasAnyTestwiseCoverage(CommitDescriptor commit) throws StorageException {
        CoverageUnitToMethodsMapIndex methodsMapIndex = this.openProjectIndex(CoverageUnitToMethodsMapIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)commit));
        return !methodsMapIndex.getPartitions().isEmpty();
    }

    private static Set<PrioritizableTest> buildPrioritizableTests(SetMap<PartitionAndPath, MethodId> testsToMethodsMapping) {
        HashSet<PrioritizableTest> prioritizableTests = new HashSet<PrioritizableTest>();
        for (Map.Entry test : testsToMethodsMapping.entrySet()) {
            PrioritizableTest prioritizableTest = new PrioritizableTest(((PartitionAndPath)test.getKey()).toUniformPath(), ETestSelectionReason.COVERS_CHANGES, ((PartitionAndPath)test.getKey()).getPartition(), (Set)test.getValue());
            prioritizableTests.add(prioritizableTest);
        }
        return prioritizableTests;
    }

    private SetMap<PartitionAndPath, MethodId> computeTestToMethodsMapping(TiaPartitionsQueryParams partitionInfo, Set<MethodId> methodIds, HistoryAccessOption historyAccessOptionOfLastCommit) throws StorageException {
        CoverageUnitToMethodsMapIndex testsToMethodsMapIndex = this.openProjectIndex(CoverageUnitToMethodsMapIndex.class, historyAccessOptionOfLastCommit);
        Map<MethodId, PartitionedTestSet> testsList = ImpactedTestUtils.computeMethodToTestsMapping(testsToMethodsMapIndex, partitionInfo, methodIds);
        SetMap testsToMethodsMapping = new SetMap();
        testsList.forEach((methodId, tests) -> {
            for (PartitionAndPath test : tests) {
                testsToMethodsMapping.add((Object)test, methodId);
            }
        });
        return testsToMethodsMapping;
    }

    private TestSuggestions.TestSuggestionSavings computeTestStats(List<PrioritizableTest> impactedTests, TiaPartitionsQueryParams partitionsQueryParams, CommitDescriptor commit) throws StorageException {
        UniformPath uniformPath;
        IMetricRetrievalStrategy metricRetrievalStrategy;
        MetricDirectoryEntry metricDirectoryEntry;
        long impactedTestsTotalRuntimeInMs = 0L;
        for (PrioritizableTest test : impactedTests) {
            impactedTestsTotalRuntimeInMs += test.getDurationInMs().orElse(0L).longValue();
        }
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)commit);
        CoverageUnitToMethodsMapIndex methodsMapIndex = this.openProjectIndex(CoverageUnitToMethodsMapIndex.class, historyAccessOption);
        HashSet partitions = new HashSet(methodsMapIndex.getPartitions());
        if (!partitionsQueryParams.isAllPartitions()) {
            partitions = CollectionUtils.intersectionSet(partitions, (Collection[])new Collection[]{partitionsQueryParams.getPartitions()});
        }
        if ((metricDirectoryEntry = (metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)(uniformPath = UniformPath.testExecutionRoot()).getType(), (Set)partitions, (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser(), (boolean)false)).getMetricDirectoryEntry(uniformPath, historyAccessOption)) == null) {
            return null;
        }
        MetricDirectorySchema schema = metricRetrievalStrategy.getMetricDirectorySchema();
        int allTestsCount = (int)((Double)metricDirectoryEntry.getValue(schema, "Count", Double.class)).doubleValue();
        long allTestsTotalRuntimeInMs = Math.round((Double)metricDirectoryEntry.getValue(schema, "Duration", Double.class) * 1000.0);
        return new TestSuggestions.TestSuggestionSavings(impactedTests.size(), allTestsCount, impactedTestsTotalRuntimeInMs, allTestsTotalRuntimeInMs);
    }
}

