/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.legacy;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.testimpact.TiaRequestOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.framework.logging.UncriticalStatusCode;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.testimpact.ImpactedTestsService;
import com.teamscale.service.testimpact.prioritization.PrioritizableTest;
import com.teamscale.service.testimpact.prioritization.PrioritizableTestCluster;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.TestWithClusterId;

@Path(value="api/projects/{project}/impacted-tests")
public class ImpactedTestsServicePre94 {
    @Context
    private ResourceContext resourceContext;

    @PublicApi(since=ETeamscaleVersion.VERSION_8_0_0, deprecatedSince=ETeamscaleVersion.VERSION_9_4_0)
    @UncriticalStatusCode(value=Response.Status.PRECONDITION_FAILED)
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @GET
    public List<PrioritizableTest> getImpactedTests(@BeanParam TiaRequestOptions tiaRequestOptions) throws StorageException, InterruptedException {
        tiaRequestOptions.getPartitionInfo().setAllPartitionsWhenPartitionsEmpty();
        return ((ImpactedTestsService)this.resourceContext.getResource(ImpactedTestsService.class)).getImpactedTests(tiaRequestOptions);
    }

    @PublicApi(since=ETeamscaleVersion.VERSION_8_0_0, deprecatedSince=ETeamscaleVersion.VERSION_9_4_0)
    @UncriticalStatusCode(value=Response.Status.PRECONDITION_FAILED)
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @PUT
    public List<PrioritizableTestCluster> getImpactedTestsFromAvailableTests(@BeanParam TiaRequestOptions tiaRequestOptions, @RequestBody List<TestWithClusterId> availableTests) throws StorageException, InterruptedException {
        tiaRequestOptions.getPartitionInfo().setAllPartitionsWhenPartitionsEmpty();
        return ((ImpactedTestsService)this.resourceContext.getResource(ImpactedTestsService.class)).getImpactedTestsFromAvailableTests(tiaRequestOptions, availableTests);
    }
}

