/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.tests;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.tests.TestExecutionIndex;
import com.teamscale.index.tests.TestExecutionWithPartition;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.index.shared.tests.ETestExecutionResult;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/test-executions/{testExecution}/history")
public class TestHistoryService
extends ApiBase {
    private static final int MAXIMUM_NUMBER_OF_ENTRIES_TO_RETURN = 20;

    @GET
    @Operation(summary="Get test history", description="Retrieves the history of executions of a specific test.", tags={"Tests"}, responses={@ApiResponse(responseCode="404", description="Could not find test executions for given parameters.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public TestHistoryWrapper getTestHistory(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor unresolvedCommitDescriptor, @Parameter(description="Uniform path to retrieve test history for") @PathParam(value="testExecution") UniformPath uniformPath, @Parameter(description="Partition to retrieve test history for") @QueryParam(value="partition") String partition) throws StorageException {
        if (!uniformPath.isTestExecutionPath()) {
            throw new BadRequestException("The given path is not a test execution.");
        }
        CommitDescriptor commit = this.resolve(unresolvedCommitDescriptor);
        ArrayList<TestExecutionWithPartition> result = new ArrayList<TestExecutionWithPartition>();
        PriorityQueue<CommitDescriptor> commitsForTest = new PriorityQueue<CommitDescriptor>();
        HashSet<CommitDescriptor> processedCommits = new HashSet<CommitDescriptor>();
        commitsForTest.add(commit);
        while (!commitsForTest.isEmpty() && result.size() < 20) {
            CommitDescriptor currentCommit = (CommitDescriptor)commitsForTest.poll();
            processedCommits.add(currentCommit);
            TestExecutionIndex testExecutionIndex = this.openProjectIndex(TestExecutionIndex.class, HistoryAccessOption.readTimestamp((String)currentCommit.getBranchName(), (long)currentCommit.getTimestamp()));
            TestExecutionWithPartition testExecutionInfo = testExecutionIndex.getTestExecution(partition, uniformPath);
            if (testExecutionInfo == null) continue;
            commitsForTest.addAll(CollectionUtils.differenceSet((Collection)testExecutionInfo.getPredecessorCommits(), (Collection[])new Collection[]{processedCommits}));
            if (result.contains(testExecutionInfo)) continue;
            result.add(testExecutionInfo);
        }
        if (result.isEmpty()) {
            throw new NotFoundException("No test execution found for the given parameters.");
        }
        result.sort(Comparator.comparing(TestExecutionWithPartition::getCommit).reversed());
        return new TestHistoryWrapper(result, commit);
    }

    private static class TestHistoryWrapper {
        @JsonProperty(value="testResultSummary")
        private final CounterSet<ETestExecutionResult> testResultSummary = new CounterSet();
        @JsonProperty(value="testHistory")
        private final List<TestExecutionWithPartition> testHistory;
        @JsonProperty(value="endCommit")
        private final CommitDescriptor endCommit;

        private TestHistoryWrapper(List<TestExecutionWithPartition> testHistory, CommitDescriptor endCommit) {
            this.testHistory = testHistory;
            this.endCommit = endCommit;
            this.testResultSummary.incAll(Arrays.asList(ETestExecutionResult.values()), 0);
            for (TestExecutionWithPartition testExecution : testHistory) {
                this.testResultSummary.inc((Object)testExecution.getTestExecution().getResult());
            }
        }
    }
}

