/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.upload;

import com.teamscale.core.concurrency.ExecuteInParallelBatchesFunction;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.rest.EHttpMethod;
import com.teamscale.core.rest.IExternalUploadRequestPart;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.configuration.CoreConfiguration;
import com.teamscale.index.dependencies.ITypeIndex;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.external.input.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.input.ExternalAnalysisSessionInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoReport;
import com.teamscale.index.project.ExternalFindingsGroupDescriptionIndex;
import com.teamscale.index.report.EReportFormat;
import com.teamscale.index.report.ReportParserFactory;
import com.teamscale.index.report.parser.IPathPrefixedReportParser;
import com.teamscale.index.report.parser.IReportParser;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementIndexCache;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.index.testimpact.CommitAndRevision;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.util.BodyPartWrapper;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.upload.ExternalReportUploadServiceQueryOptions;
import com.teamscale.service.upload.base.ExternalUploadServiceUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="api/projects/{project}/external-analysis/session/{sessionId}/report")
public class ExternalReportUploadService
extends SessionBasedExternalAnalysisServiceBase<ExternalReportUploadServiceQueryOptions> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String REPORT_PARAMETER_DESCRIPTION = "The external analysis report(s) to upload to Teamscale. The reports are expected to be UTF-8 encoded, other encodings need to be specified.\n\nNote: Files that are *not* encoded in UTF-8, or without a BOM, and are not specified as such, cannot be read reliably, which might lead to parsing errors. For more information on uploading external analysis reports, see https://docs.teamscale.com/howto/uploading-external-data.";
    private static final Set<EReportFormat> IGNORED_REPORT_FORMATS = (Set)StringUtils.splitToList((String)System.getProperty("com.teamscale.ignored-report-formats"), (String)",").stream().map(value -> (EReportFormat)EnumUtils.valueOfIgnoreCase(EReportFormat.class, (String)value)).collect(CollectionUtils.toEnumSet(EReportFormat.class));

    @POST
    @PublicApi(since=ETeamscaleVersion.VERSION_5_9_0)
    @Operation(summary="Upload external report(s)", description="Adds external reports to the session. For performance reasons, it is recommended to batch calls to this service, i.e. not commit all files using single calls.", tags={"External Analysis"}, responses={@ApiResponse(responseCode="404", description="No session with provided id found."), @ApiResponse(responseCode="400", description="Partition name not provided."), @ApiResponse(responseCode="400", description="Provided partition name is different from the one used to create the session."), @ApiResponse(responseCode="400", description="Provided upload message is different from the one used to create the session."), @ApiResponse(responseCode="404", description="Revision provided in the query parameter could not be found."), @ApiResponse(responseCode="400", description="Session has been committed or deleted."), @ApiResponse(responseCode="400", description="Upload was rejected, because it refers to a timestamp too far back in time."), @ApiResponse(responseCode="400", description="Upload format is not supported by Teamscale."), @ApiResponse(responseCode="400", description="Upload format is not supported for upload."), @ApiResponse(responseCode="400", description="No reports provided via the report multi-part form data parameter"), @ApiResponse(responseCode="400", description="The required analyses or tools for the external upload of the report are enabled."), @ApiResponse(responseCode="400", description="Empty revision provided. Please specify a valid revision.")})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    @Consumes(value={"multipart/form-data"})
    public void uploadReport(@Parameter(description="If session ID is provided, the results will be appended to the given session instead of creating a new session. Use \"auto-create\" in place of session ID to create a new session, perform upload and commit session in one step.") @PathParam(value="sessionId") String sessionId, @BeanParam ExternalReportUploadServiceQueryOptions parameters, @Parameter(required=true, description="The external analysis report(s) to upload to Teamscale. The reports are expected to be UTF-8 encoded, other encodings need to be specified.\n\nNote: Files that are *not* encoded in UTF-8, or without a BOM, and are not specified as such, cannot be read reliably, which might lead to parsing errors. For more information on uploading external analysis reports, see https://docs.teamscale.com/howto/uploading-external-data.", array=@ArraySchema(schema=@Schema(type="string", format="binary"))) @FormDataParam(value="report") List<FormDataBodyPart> reports) throws StorageException, IOException {
        String revision = parameters.getCommitAndRevision().revision();
        if (revision != null && revision.isEmpty()) {
            throw new BadRequestException("Empty revision provided. Please specify a valid revision.");
        }
        if (IGNORED_REPORT_FORMATS.contains(parameters.getFormat())) {
            CommitAndRevision commitAndRevision = parameters.getCommitAndRevision();
            LOGGER.warn("Ignored " + String.valueOf(parameters.getFormat()) + " report uploaded to " + parameters.getPartition() + " for commit " + String.valueOf(commitAndRevision.commit()) + "/" + commitAndRevision.repository() + "/" + commitAndRevision.revision());
            return;
        }
        this.logManager.logParameter("path-prefix", parameters.getPathPrefix());
        this.logManager.logParameter("format", parameters.getFormat().getReadableName());
        List<BodyPartWrapper> bodyParts = ExternalReportUploadService.readFormDataBodyParts(reports);
        this.logManager.logReports(bodyParts);
        this.process(EHttpMethod.POST, new ArrayList<BodyPartWrapper>(bodyParts), parameters, sessionId);
    }

    @Override
    protected void processRequest(ExternalAnalysisSessionInfo session, ExternalAnalysisImportSessionIndex sessionIndex, List<IExternalUploadRequestPart> bodyParts, ExternalReportUploadServiceQueryOptions parameters) throws BadRequestException, StorageException {
        HistoryAccessOption defaultBranchAccessOption = ExternalUploadServiceUtils.getAccessOptionForDefaultBranch(session.getCommit());
        EReportFormat uploadFormat = ExternalReportUploadService.checkUploadFormat(parameters.getFormat());
        this.checkParserPreconditions(parameters, defaultBranchAccessOption);
        ExternalAnalysisImportInfoReport.Builder builder = new ExternalAnalysisImportInfoReport.Builder(parameters.getPathPrefix(), uploadFormat);
        for (IExternalUploadRequestPart part : bodyParts) {
            BodyPartWrapper bodyPartWrapper = (BodyPartWrapper)part;
            builder.addReport(bodyPartWrapper.getFileName(), bodyPartWrapper.getBodyPart());
        }
        builder.addRepositoryId(parameters.getRepositoryId());
        sessionIndex.insertAndMergeImportInfos(session, Collections.singletonList(builder.build()));
    }

    private static EReportFormat checkUploadFormat(EReportFormat uploadFormat) throws BadRequestException {
        if (!uploadFormat.isAllowedForUpload()) {
            throw new BadRequestException("Upload format is not supported for upload: " + uploadFormat.getReadableName());
        }
        return uploadFormat;
    }

    private void checkParserPreconditions(ExternalReportUploadServiceQueryOptions parameters, HistoryAccessOption defaultBranchAccessOption) throws StorageException {
        IReportParser reportParser = this.getReportParser(parameters, defaultBranchAccessOption);
        List analysisProfiles = AnalysisProfileUtils.getEmbeddedAnalysisProfiles((ProjectStorageSystem)this.getProjectStorageSystem());
        try {
            reportParser.checkEnabledAnalysesAndTools(analysisProfiles, this.serviceInfo.getPrimaryPublicId());
        }
        catch (ConQATException e) {
            throw new BadRequestException("The required analyses or tools for the external upload of the report are not enabled.", (Throwable)e);
        }
    }

    private IReportParser getReportParser(ExternalReportUploadServiceQueryOptions parameters, HistoryAccessOption historyAccessOption) throws BadRequestException, StorageException {
        String pathPrefix;
        IReportParser reportParser = ReportParserFactory.createParser((EReportFormat)parameters.getFormat());
        TokenElementIndex tokenElementIndex = this.openProjectIndex(TokenElementIndex.class, "content", historyAccessOption);
        TokenElementLineInfoIndex tokenElementLineInfoIndex = this.openProjectIndex(TokenElementLineInfoIndex.class, historyAccessOption);
        BinaryElementIndex binaryElementIndex = this.openProjectIndex(BinaryElementIndex.class, historyAccessOption);
        PathLookupIndex pathLookupIndex = this.openProjectIndex(PathLookupIndex.class, historyAccessOption);
        TypeIndex typeIndex = this.openProjectIndex(TypeIndex.class, historyAccessOption);
        ExternalFindingsGroupDescriptionIndex externalFindingsGroupDescriptionIndex = (ExternalFindingsGroupDescriptionIndex)this.getGlobalStorageSystem().openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
        reportParser.init(new TokenElementIndexCache(tokenElementIndex, Collections.emptyList()), tokenElementLineInfoIndex, binaryElementIndex, (IMatchingPathsLookup)pathLookupIndex, (ITypeIndex)typeIndex, externalFindingsGroupDescriptionIndex, null, this.openProjectIndex(MetaIndex.class, null), CoreConfiguration.hasDisabledImplausibleLinesCheck((ProjectStorageSystem)this.serviceInfo.getProjectStorageSystem()), ExecuteInParallelBatchesFunction.createSingleThreadedExecutor(), parameters.getRepositoryId());
        if (reportParser instanceof IPathPrefixedReportParser && (pathPrefix = parameters.getPathPrefix()) != null) {
            ((IPathPrefixedReportParser)reportParser).setPathPrefix(pathPrefix);
        }
        return reportParser;
    }
}

