/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.upload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreator;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.index.external.ExternalStorageBackendOption;
import com.teamscale.index.external.input.external_storage.EExternalStorageBackendProtocol;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackendIndex;
import com.teamscale.index.repository.artifact_store.ArtifactStoreUtils;
import com.teamscale.service.base.ElementListServiceBase;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.permissions.PermissionFilterUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotAllowedException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

@Path(value="api/external-storage-backends")
public class ExternalStorageService
extends ElementListServiceBase<ExternalStorageBackendData> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FORCE_DELETION_PARAMETER_NAME = "force-deletion";
    private static boolean shouldCheckConnection = true;

    @VisibleForTesting
    public static AutoCloseable disableConnectionCheck() {
        shouldCheckConnection = false;
        return () -> {
            shouldCheckConnection = true;
        };
    }

    @GET
    @Operation(summary="Get all external storages", description="Retrieves all available external storages.", tags={"External Storage Backends"})
    @RequiresNoPermission(description="No permissions needed, as the service will only return backends visible to current user.")
    public List<ExternalStorageBackendData> getAllExternalStorageBackends() throws StorageException {
        if (ExternalStorageService.isOverwriteFeatureToggleEnabled()) {
            return CollectionUtils.emptyList();
        }
        return CollectionUtils.map(PermissionFilterUtils.getVisibleExternalStorageBackends(this.getPermissions(), this.openGlobalIndex(ExternalStorageBackendIndex.class)), ExternalStorageBackendData::new);
    }

    @DELETE
    @RequiresBasicPermission(scope=EBasicPermissionScope.EXTERNAL_STORAGE_BACKENDS, permissions={EBasicPermission.DELETE}, entityPathParameter="externalStorageBackendName")
    @Operation(summary="Delete external storages", description="Deletes the external storages identified by the given name from the system", tags={"External Storage Backends"}, responses={@ApiResponse(responseCode="404", description="External storages identified by the given name do not exist in the system."), @ApiResponse(responseCode="400", description="External storages identified by the given name are used by at least one existing project."), @ApiResponse(responseCode="400", description="External storages identified by the given name refer to an unknown connector or connector type."), @ApiResponse(responseCode="400", description="Update of external storages rejected due to project validation error.")})
    @Path(value="{externalStorageBackendName}")
    public void deleteExternalStorageBackend(@Parameter(description="Name of the external storage to delete") @PathParam(value="externalStorageBackendName") String externalStorageBackendName, @Parameter(description="Force deletion of the external storage.") @QueryParam(value="force-deletion") boolean skipValidation) throws StorageException, TriggerCompilationException, ProjectConfigurationException {
        ExternalStorageService.checkOverwriteFeatureToggle();
        ExternalStorageBackendData externalStorageBackend = (ExternalStorageBackendData)this.getElementWithExistsCheck(externalStorageBackendName);
        this.deleteExternalStorageBackendWithValidation(externalStorageBackend, skipValidation);
    }

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_EXTERNAL_STORAGE_BACKENDS})
    @Operation(summary="Create external storage", description="Creates new external storage.", tags={"External Storage Backends"}, responses={@ApiResponse(responseCode="400", description="Storage name in the provided storage is null or empty."), @ApiResponse(responseCode="400", description="Credentials name in the provided storage is null or empty."), @ApiResponse(responseCode="400", description="Credentials name in the provided storage does not reference existing credentials."), @ApiResponse(responseCode="400", description="Bucket/repository name in the provided storage is null or empty.")})
    public void createExternalStorageBackend(@RequestBody(required=true) ExternalStorageBackendData newValue) throws StorageException {
        ExternalStorageService.checkOverwriteFeatureToggle();
        this.createElementAndPermissions(newValue);
    }

    @PUT
    @RequiresBasicPermission(scope=EBasicPermissionScope.EXTERNAL_STORAGE_BACKENDS, permissions={EBasicPermission.EDIT}, entityPathParameter="externalStorageBackendName")
    @Operation(summary="Update external storages", description="Updates the external storage identified by the given name with the value in the request body.", tags={"External Storage Backends"}, responses={@ApiResponse(responseCode="400", description="No storage with the given name exists."), @ApiResponse(responseCode="400", description="Credentials name in the provided storage is null or empty."), @ApiResponse(responseCode="400", description="Credentials name in the provided storage does not reference existing credentials."), @ApiResponse(responseCode="400", description="Bucket/repository name in the provided storage is null or empty."), @ApiResponse(responseCode="400", description="Storage name in the provided external storage is different from the name in the existing backend.")})
    @Path(value="{externalStorageBackendName}")
    public void updateExternalStorageBackend(@RequestBody(required=true) ExternalStorageBackendData newValue, @Parameter(description="Name of the external storage which should be updated.") @PathParam(value="externalStorageBackendName") String externalStorageBackendName) throws StorageException {
        ExternalStorageService.checkOverwriteFeatureToggle();
        ExternalStorageBackendData externalStorageBackendData = (ExternalStorageBackendData)this.getElementWithExistsCheck(externalStorageBackendName);
        this.updateElement(externalStorageBackendData, newValue);
    }

    @Override
    protected void createPermissions(ExternalStorageBackendData newElement) throws StorageException {
        this.getPermissions().createPermissionModifier().makeCurrentUserOwner(EBasicPermissionScope.EXTERNAL_STORAGE_BACKENDS, newElement.externalStorageBackendName);
    }

    @Override
    protected @Nullable ExternalStorageBackendData getElement(String elementName) throws StorageException {
        return this.openGlobalIndex(ExternalStorageBackendIndex.class).getExternalStorageBackend(elementName).map(ExternalStorageBackendData::new).orElse(null);
    }

    @Override
    protected void deleteElement(ExternalStorageBackendData externalStorageBackend) throws StorageException {
        this.openGlobalIndex(ExternalStorageBackendIndex.class).deleteExternalStorageBackend(externalStorageBackend.toInternalObject());
    }

    @Override
    protected void deletePermissions(ExternalStorageBackendData externalStorageBackendData) throws StorageException {
        this.getPermissions().createPermissionModifier().removeBasicRoleInstanceAssignments(EBasicPermissionScope.EXTERNAL_STORAGE_BACKENDS, externalStorageBackendData.externalStorageBackendName);
    }

    @Override
    protected void updateElement(ExternalStorageBackendData oldExternalStorage, ExternalStorageBackendData updatedExternalStorage) throws StorageException, BadRequestException {
        if (!oldExternalStorage.externalStorageBackendName.equals(updatedExternalStorage.externalStorageBackendName)) {
            throw new BadRequestException("External storages can't be renamed. Delete old external storage and create a new one instead.");
        }
        this.validateAndStore(updatedExternalStorage, this.openGlobalIndex(ExternalStorageBackendIndex.class));
        LOGGER.info("Successfully updated '{}'.", (Object)updatedExternalStorage.externalStorageBackendName);
    }

    @Override
    protected void createElement(ExternalStorageBackendData newExternalStorage) throws StorageException, BadRequestException {
        ExternalStorageBackendIndex index = this.openGlobalIndex(ExternalStorageBackendIndex.class);
        if (index.getExternalStorageBackend(newExternalStorage.externalStorageBackendName).isPresent()) {
            throw new BadRequestException("External storage with name '%s' already exists.".formatted(newExternalStorage.externalStorageBackendName));
        }
        this.validateAndStore(newExternalStorage, index);
        LOGGER.info("Successfully created '{}'.", (Object)newExternalStorage.externalStorageBackendName);
    }

    private void validateAndStore(ExternalStorageBackendData newExternalStorageBackend, ExternalStorageBackendIndex index) throws StorageException {
        ExternalStorageBackend actualExternalStorageBackend = newExternalStorageBackend.toInternalObject();
        this.validateExternalStorageBackend(actualExternalStorageBackend, (IExternalCredentialsProvider)this.openGlobalIndex(ExternalCredentialsIndex.class));
        index.setExternalStorageBackend(actualExternalStorageBackend);
    }

    private void validateExternalStorageBackend(ExternalStorageBackend newExternalStorageBackend, IExternalCredentialsProvider credentialsProvider) throws BadRequestException, StorageException {
        if (StringUtils.isEmpty((String)newExternalStorageBackend.externalStorageBackendName())) {
            throw new BadRequestException("External storage name can't be null or empty.");
        }
        if (StringUtils.isEmpty((String)newExternalStorageBackend.credentialsName())) {
            throw new BadRequestException("Credentials name can't be null or empty.");
        }
        ExternalCredentials externalCredentials = credentialsProvider.getExternalCredentials(newExternalStorageBackend.credentialsName());
        if (externalCredentials == null) {
            throw new BadRequestException("Could not find the referenced credentials.");
        }
        if (StringUtils.isEmpty((String)newExternalStorageBackend.repositoryOrBucketName())) {
            throw new BadRequestException("Repository/bucket name can't be null or empty.");
        }
        if (StringUtils.startsWithOneOf((String)newExternalStorageBackend.uploadPathPrefix(), (String[])new String[]{"/"})) {
            throw new BadRequestException("The upload path prefix can't have a leading slash (\"/\").");
        }
        this.validateConnectionToExternalStorageBackend(newExternalStorageBackend, externalCredentials);
    }

    private void validateConnectionToExternalStorageBackend(ExternalStorageBackend newExternalStorageBackend, ExternalCredentials externalCredentials) throws BadRequestException, StorageException {
        if (!shouldCheckConnection) {
            return;
        }
        try {
            ArtifactStoreUtils.getClientForProtocol((ExternalStorageBackend)newExternalStorageBackend, (ExternalCredentials)externalCredentials, (IndexLayer)this.getIndexLayer()).testConnection(newExternalStorageBackend.repositoryOrBucketName(), newExternalStorageBackend.uploadPathPrefix());
        }
        catch (ProjectConfigurationException | RepositoryException e) {
            throw new BadRequestException(e);
        }
    }

    private void deleteExternalStorageBackendWithValidation(ExternalStorageBackendData externalStorageBackend, boolean skipValidation) throws StorageException, TriggerCompilationException, ProjectConfigurationException {
        if (!skipValidation) {
            ListMap errorsByProject = new ListMap();
            this.validateNotGlobalDefaultStorageBackend(externalStorageBackend, (ListMap<String, String>)errorsByProject);
            this.validateNotUsedByAnyProjects(externalStorageBackend, (ListMap<String, String>)errorsByProject);
            if (!errorsByProject.isEmpty()) {
                throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorsByProject.collectionsToArrays(String.class)).build());
            }
        } else {
            this.resetGlobalDefault(externalStorageBackend);
            this.resetAffectedProjects(externalStorageBackend);
        }
        this.deleteElementAndPermissions(externalStorageBackend);
    }

    private void validateNotUsedByAnyProjects(ExternalStorageBackendData externalStorageBackend, ListMap<String, String> errorsByProject) throws StorageException {
        ListMap<PublicProjectId, ProjectConfiguration> affectedProjects = this.getAffectedProjects(externalStorageBackend);
        for (PublicProjectId project : affectedProjects.getKeys()) {
            errorsByProject.add((Object)project.projectId, (Object)"External storage is used by this project.");
        }
    }

    private void validateNotGlobalDefaultStorageBackend(ExternalStorageBackendData externalStorageBackend, ListMap<String, String> errorsByProject) throws StorageException {
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)this.getGlobalStorageSystem().openGlobalIndex(ServerOptionIndex.class);
        Optional<String> globalDefaultStorageBackend = ExternalStorageService.getGlobalDefaultStorageBackend(serverOptionIndex);
        if (globalDefaultStorageBackend.isPresent() && Objects.equals(globalDefaultStorageBackend.get(), externalStorageBackend.externalStorageBackendName)) {
            errorsByProject.add((Object)"All Projects (Global Default)", (Object)"External storage is used as global default.");
        }
    }

    private static Optional<String> getGlobalDefaultStorageBackend(ServerOptionIndex optionIndex) throws StorageException {
        return Optional.ofNullable((ExternalStorageBackendOption)ServerOptionRegistry.getInstance().getOption("server", "default-external-storage-backend", null, ExternalStorageBackendOption.class, (OptionIndexBase)optionIndex)).map(option -> option.defaultExternalStorageBackend);
    }

    private void resetAffectedProjects(ExternalStorageBackendData externalStorageBackend) throws StorageException, TriggerCompilationException, ProjectConfigurationException {
        ProjectCreator projectCreator = new ProjectCreator(this.getIndexLayer(), this.getUser().getUsername(), ConfigurationInitializationContext.EInitializationReason.PROJECT_CREATION);
        ListMap<PublicProjectId, ProjectConfiguration> affectedProjects = this.getAffectedProjects(externalStorageBackend);
        for (ProjectConfiguration projectConfiguration : (List)affectedProjects.getValues()) {
            projectConfiguration.setExternalStorageBackend(null);
            projectCreator.refreshProject(projectConfiguration, false, false, true, false);
        }
    }

    private void resetGlobalDefault(ExternalStorageBackendData externalStorageBackend) throws StorageException {
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)this.getGlobalStorageSystem().openGlobalIndex(ServerOptionIndex.class);
        Optional<String> globalDefaultStorageBackend = ExternalStorageService.getGlobalDefaultStorageBackend(serverOptionIndex);
        if (globalDefaultStorageBackend.isPresent() && Objects.equals(globalDefaultStorageBackend.get(), externalStorageBackend.externalStorageBackendName)) {
            serverOptionIndex.setOption("server:default-external-storage-backend", (IOption)new ExternalStorageBackendOption());
        }
    }

    private ListMap<PublicProjectId, ProjectConfiguration> getAffectedProjects(ExternalStorageBackendData externalStorage) throws StorageException {
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        ListMap affectedProjects = new ListMap();
        for (ProjectInfo projectInfo : projectIndex.getAllProjectInfos()) {
            ProjectConfiguration configuration;
            if (projectInfo.isDeleting() || !Objects.equals((configuration = ProjectConfigurationUtils.getProjectConfiguration((ProjectInfo)projectInfo, (IndexLayer)this.getIndexLayer())).getExternalStorageBackend(), externalStorage.externalStorageBackendName)) continue;
            affectedProjects.add((Object)projectInfo.getPrimaryPublicId(), (Object)configuration);
        }
        return affectedProjects;
    }

    private static void checkOverwriteFeatureToggle() throws NotAllowedException {
        if (ExternalStorageService.isOverwriteFeatureToggleEnabled()) {
            throw new NotAllowedException("External storage is not configurable on this server.", new String[0]);
        }
    }

    private static boolean isOverwriteFeatureToggleEnabled() {
        return EFeatureToggle.OVERWRITE_EXTERNAL_STORAGE.isEnabled();
    }

    public static final class ExternalStorageBackendData {
        private static final String EXTERNAL_STORAGE_BACKEND_NAME_PROPERTY = "externalStorageBackendName";
        private static final String CREDENTIALS_NAME_PROPERTY = "credentialsName";
        private static final String BACKEND_PROTOCOL_PROPERTY = "backendProtocol";
        private static final String REPOSITORY_OR_BUCKET_NAME_PROPERTY = "repositoryOrBucketName";
        private static final String USE_S3_CREDENTIALS_PROCESS_PROPERTY = "useS3CredentialsProcess";
        private static final String UPLOAD_PATH_PREFIX_PROPERTY = "uploadPathPrefix";
        @JsonProperty(value="uploadPathPrefix")
        public final String uploadPathPrefix;
        @JsonProperty(value="externalStorageBackendName")
        public final String externalStorageBackendName;
        @JsonProperty(value="credentialsName")
        public final String credentialsName;
        @JsonProperty(value="backendProtocol")
        public final EExternalStorageBackendProtocol backendProtocol;
        @JsonProperty(value="repositoryOrBucketName")
        public final String repositoryOrBucketName;
        @JsonProperty(value="useS3CredentialsProcess")
        public final boolean useS3CredentialsProcess;

        @VisibleForTesting
        public ExternalStorageBackendData(ExternalStorageBackend externalStorageBackend) {
            this.externalStorageBackendName = externalStorageBackend.externalStorageBackendName();
            this.credentialsName = externalStorageBackend.credentialsName();
            this.backendProtocol = externalStorageBackend.backendProtocol();
            this.repositoryOrBucketName = externalStorageBackend.repositoryOrBucketName();
            this.uploadPathPrefix = externalStorageBackend.uploadPathPrefix();
            this.useS3CredentialsProcess = externalStorageBackend.useS3CredentialsProcess();
        }

        @JsonCreator
        public ExternalStorageBackendData(@JsonProperty(value="externalStorageBackendName") String externalStorageBackendName, @JsonProperty(value="credentialsName") String credentialsName, @JsonProperty(value="backendProtocol") EExternalStorageBackendProtocol backendProtocol, @JsonProperty(value="repositoryOrBucketName") String repositoryOrBucketName, @JsonProperty(value="uploadPathPrefix") String uploadPathPrefix, @JsonProperty(value="useS3CredentialsProcess") boolean useS3CredentialsProcess) {
            this.externalStorageBackendName = externalStorageBackendName;
            this.credentialsName = credentialsName;
            this.backendProtocol = backendProtocol;
            this.uploadPathPrefix = uploadPathPrefix;
            this.repositoryOrBucketName = repositoryOrBucketName;
            this.useS3CredentialsProcess = useS3CredentialsProcess;
        }

        public ExternalStorageBackend toInternalObject() {
            return new ExternalStorageBackend(this.externalStorageBackendName, this.credentialsName, this.backendProtocol, this.repositoryOrBucketName, this.uploadPathPrefix, this.useS3CredentialsProcess);
        }
    }
}

