/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.upload.base;

import com.teamscale.index.testimpact.CommitAndRevision;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;

public class ExternalUploadServiceQueryOptions {
    public static final String REVISION_PARAMETER_NAME = "revision";
    public static final String REPOSITORY_PARAMETER_NAME = "repository";
    private static final String REVISION_PARAMETER_DESCRIPTION = "This parameter allows to pass a revision instead of a timestamp.";
    private static final String REPOSITORY_PARAMETER_DESCRIPTION = "When using the revision parameter, this parameter allows to pass a repository ID (see connectors in project) which is used to identify the correct commit in situations where the same revision exists in multiple repositories.";
    @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.")
    @QueryParam(value="t")
    private UnresolvedCommitDescriptor commit;
    @Parameter(description="This parameter allows to pass a revision instead of a timestamp.")
    @QueryParam(value="revision")
    private String revision;
    @Parameter(description="When using the revision parameter, this parameter allows to pass a repository ID (see connectors in project) which is used to identify the correct commit in situations where the same revision exists in multiple repositories.")
    @QueryParam(value="repository")
    private String repository;

    public ExternalUploadServiceQueryOptions(ExternalUploadServiceQueryOptions other) {
        this.commit = other.commit;
        this.revision = other.revision;
        this.repository = other.repository;
    }

    public ExternalUploadServiceQueryOptions() {
    }

    public CommitAndRevision getCommitAndRevision() {
        return new CommitAndRevision(this.commit, this.revision, this.repository);
    }

    public void setCommit(UnresolvedCommitDescriptor commit) {
        this.commit = commit;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void setRepositoryId(String repositoryId) {
        this.repository = repositoryId;
    }

    public String getRepositoryId() {
        return this.repository;
    }
}

