/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.user.debug;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/user/debug/user-group-mapping")
public class UserGroupMappingDebugService
extends ApiBase {
    private UserIndex userIndex;
    private UserGroupIndex groupIndex;
    private Map<String, UserGroup> groupIndexEntries;
    private Map<String, User> userIndexEntries;

    @GET
    @Operation(summary="Get inconsistent user-group mappings", description="Returns inconsistent user-group mappings.It only adds missing group-memberships to user profiles and missing users to groups.and is not guarded against concurrent changes to user profiles or groups!", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/plain"})
    public String getInconsistentUserGroupMappings() throws StorageException {
        this.setup();
        SetMap<String, String> unknownUsersInGroups = this.getUnknownUsersInGroups();
        SetMap<String, String> missingGroupsInUserProfiles = this.getMissingGroupsInUserProfiles();
        SetMap<String, String> missingUsersInGroups = this.getMissingUsersInGroups();
        SetMap<String, String> unknownGroupsInUserProfiles = this.getUnknownGroupsInUserProfiles();
        return UserGroupMappingDebugService.generateResultMessage(unknownUsersInGroups, missingUsersInGroups, unknownGroupsInUserProfiles, missingGroupsInUserProfiles);
    }

    @POST
    @Operation(summary="Fix inconsistent user-group mappings", description="Fixes and returns inconsistent user-group mappings. This does not change permissions of users or groups. The service only adds missing group-memberships to user profiles and missing users to groups and is not guarded against concurrent changes to user profiles or groups!", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/plain"})
    public String fixInconsistentUserGroupMappings() throws StorageException {
        this.setup();
        SetMap<String, String> unknownUsersInGroups = this.getUnknownUsersInGroups();
        SetMap<String, String> missingGroupsInUserProfiles = this.getMissingGroupsInUserProfiles();
        SetMap<String, String> missingUsersInGroups = this.getMissingUsersInGroups();
        SetMap<String, String> unknownGroupsInUserProfiles = this.getUnknownGroupsInUserProfiles();
        String message = this.fixInconsistencies(unknownUsersInGroups, missingGroupsInUserProfiles, missingUsersInGroups, unknownGroupsInUserProfiles);
        return UserGroupMappingDebugService.generateResultMessage(unknownUsersInGroups, missingUsersInGroups, unknownGroupsInUserProfiles, missingGroupsInUserProfiles) + message;
    }

    private void setup() throws StorageException {
        this.userIndex = this.openGlobalIndex(UserIndex.class);
        this.groupIndex = this.openGlobalIndex(UserGroupIndex.class);
        this.groupIndexEntries = this.groupIndex.getAllUserGroups().toMap();
        this.userIndexEntries = this.userIndex.getAllEntries().toMap();
    }

    private String fixInconsistencies(SetMap<String, String> unknownUsersInGroups, SetMap<String, String> missingGroupsInUserProfiles, SetMap<String, String> missingUsersInGroups, SetMap<String, String> unknownGroupsInUserProfiles) throws StorageException {
        this.fixInconsistentUserProfiles(unknownGroupsInUserProfiles, missingGroupsInUserProfiles);
        Set<String> externallySynchronizedUpdatedGroups = this.fixInconsistentGroups(unknownUsersInGroups, missingUsersInGroups);
        if (!externallySynchronizedUpdatedGroups.isEmpty()) {
            return "\n\nWarning!\n\nFixed inconsistent groups synchronized form third party authentication tools. Please synchronize groups and users again via the groups and users page in the UI.\n\nGroups: " + String.valueOf(externallySynchronizedUpdatedGroups);
        }
        return "";
    }

    private void fixInconsistentUserProfiles(SetMap<String, String> toRemove, SetMap<String, String> toAdd) throws StorageException {
        ArrayList<User> changedUsers = new ArrayList<User>();
        for (String userName : CollectionUtils.unionSet((Collection)toRemove.getKeys(), (Collection[])new Collection[]{toAdd.getKeys()})) {
            User user = this.userIndexEntries.get(userName);
            HashSet groupNames = new HashSet(user.getGroupIds());
            groupNames.removeAll(toRemove.getCollectionOrEmpty((Object)userName));
            groupNames.addAll(toAdd.getCollectionOrEmpty((Object)userName));
            user.setGroupIds(groupNames);
            changedUsers.add(user);
        }
        this.userIndex.setUsers(changedUsers, this.serviceInfo.getMessageBroker());
    }

    private Set<String> fixInconsistentGroups(SetMap<String, String> toRemove, SetMap<String, String> toAdd) throws StorageException {
        ArrayList<UserGroup> updatedGroups = new ArrayList<UserGroup>();
        HashSet<String> externallySynchronizedUpdatedGroups = new HashSet<String>();
        for (String groupName : CollectionUtils.unionSet((Collection)toRemove.getKeys(), (Collection[])new Collection[]{toAdd.getKeys()})) {
            UserGroup group = this.groupIndexEntries.get(groupName);
            HashSet userNames = new HashSet(group.getUserNames());
            if (group.getAuthenticationTool() != EAuthenticationTool.TEAMSCALE) {
                externallySynchronizedUpdatedGroups.add(groupName);
            }
            userNames.removeAll(toRemove.getCollectionOrEmpty((Object)groupName));
            userNames.addAll(toAdd.getCollectionOrEmpty((Object)groupName));
            group.setUserNames(userNames);
            updatedGroups.add(group);
        }
        this.groupIndex.setGroups(updatedGroups);
        return externallySynchronizedUpdatedGroups;
    }

    private static String generateResultMessage(SetMap<String, String> unknownUsersInGroups, SetMap<String, String> missingUsersInGroups, SetMap<String, String> unknownGroupsInUserProfiles, SetMap<String, String> missingGroupsInUserProfiles) {
        StringBuilder stringBuilder = new StringBuilder();
        int numIssues = unknownUsersInGroups.getValueCount() + missingUsersInGroups.getValueCount() + unknownGroupsInUserProfiles.getValueCount() + missingGroupsInUserProfiles.getValueCount();
        stringBuilder.append("Found ").append(numIssues).append(" issues.\nPlease use fixInconsistentUserGroupMappings service to automatically fix these issues.\n\n");
        stringBuilder.append("Groups\n");
        UserGroupMappingDebugService.appendCategoryToStringBuilder(unknownUsersInGroups, "Unknown Users", "Unknown users in group ", stringBuilder);
        UserGroupMappingDebugService.appendCategoryToStringBuilder(missingUsersInGroups, "Missing Users", "Users missing in group ", stringBuilder);
        stringBuilder.append("User Profiles\n");
        UserGroupMappingDebugService.appendCategoryToStringBuilder(unknownGroupsInUserProfiles, "Unknown Groups", "Unknown groups in user profile ", stringBuilder);
        UserGroupMappingDebugService.appendCategoryToStringBuilder(missingGroupsInUserProfiles, "Missing Groups", "Groups missing in user profile ", stringBuilder);
        return stringBuilder.toString();
    }

    private static void appendCategoryToStringBuilder(SetMap<String, String> messageCategoryElements, String category, String messagePrefix, StringBuilder stringBuilder) {
        stringBuilder.append("\t").append(category).append("\n");
        for (String key : CollectionUtils.sort((Collection)messageCategoryElements.getKeys())) {
            ArrayList value = CollectionUtils.sort((Collection)messageCategoryElements.getCollection((Object)key));
            stringBuilder.append("\t\t").append(messagePrefix).append(key).append(": ").append(StringUtils.concat((Iterable)value, (String)", ")).append("\n");
        }
        if (messageCategoryElements.size() == 0) {
            stringBuilder.append("\t\tnone\n");
        }
    }

    private SetMap<String, String> getUnknownUsersInGroups() {
        SetMap unknownUsersInGroups = new SetMap();
        for (Map.Entry<String, UserGroup> group : this.groupIndexEntries.entrySet()) {
            String groupName = group.getKey();
            group.getValue().getUserNames().stream().filter(username -> this.userIndexEntries.get(username) == null).forEach(username -> unknownUsersInGroups.add((Object)groupName, username));
        }
        return unknownUsersInGroups;
    }

    private SetMap<String, String> getMissingGroupsInUserProfiles() {
        SetMap missingGroupsInUserProfiles = new SetMap();
        for (Map.Entry<String, UserGroup> group : this.groupIndexEntries.entrySet()) {
            String groupName = group.getKey();
            group.getValue().getUserNames().stream().filter(username -> this.userIndexEntries.get(username) != null && !this.userIndexEntries.get(username).getGroupIds().contains(groupName)).forEach(username -> missingGroupsInUserProfiles.add((Object)groupName, username));
        }
        return missingGroupsInUserProfiles;
    }

    private SetMap<String, String> getUnknownGroupsInUserProfiles() {
        SetMap unknownGroupsInUserProfiles = new SetMap();
        for (Map.Entry<String, User> user : this.userIndexEntries.entrySet()) {
            String userName = user.getKey();
            user.getValue().getGroupIds().stream().filter(groupName -> this.groupIndexEntries.get(groupName) == null).forEach(groupName -> unknownGroupsInUserProfiles.add((Object)userName, groupName));
        }
        return unknownGroupsInUserProfiles;
    }

    private SetMap<String, String> getMissingUsersInGroups() {
        SetMap missingUsersInGroups = new SetMap();
        for (Map.Entry<String, User> user : this.userIndexEntries.entrySet()) {
            String userName = user.getKey();
            user.getValue().getGroupIds().stream().filter(groupName -> this.groupIndexEntries.get(groupName) != null && !this.groupIndexEntries.get(groupName).getUserNames().contains((Object)userName)).forEach(groupName -> missingUsersInGroups.add(groupName, (Object)userName));
        }
        return missingUsersInGroups;
    }
}

