/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.webhook;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.repository.RepositoryUpdateUtils;
import com.teamscale.index.repository.git.GitUtils;
import com.teamscale.index.repository.git.gitlab.GitLabChangeRetriever;
import com.teamscale.index.repository.git.gitlab.GitLabMergeRequestUpdateTrigger;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.service.webhook.GitManagementPlatformWebhookServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;
import org.intellij.lang.annotations.Language;

@Path(value="api/gitlab/web-hook")
public class GitLabWebHookService
extends GitManagementPlatformWebhookServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();

    public GitLabWebHookService() {
        super(GitLabChangeRetriever.class);
    }

    @POST
    @Operation(summary="Handles the incoming requests from the GitLab server.", description="Handles the incoming requests from the GitLab server and processes the request body depending on the event. The events which are handled by the service are 'Push Hook' and 'Merge Request Hook'.", tags={"Voting Connectors"})
    @Consumes(value={"application/json"})
    @RequiresNoLogin
    public Response processWebHook(@HeaderParam(value="X-Gitlab-Event") String event, @RequestBody byte[] requestBody) throws StorageException {
        String payload = StringUtils.bytesToString((byte[])requestBody);
        LOGGER.debug("Received a web hook request from Gitlab with event \"{}\" and payload: {}", (Object)event, (Object)payload);
        if (StringUtils.isEmpty((String)event)) {
            throw new BadRequestException("Event header missing!");
        }
        switch (event) {
            case "Push Hook": {
                this.handlePushEvent(payload);
                break;
            }
            case "Merge Request Hook": {
                this.handleMergeRequestEvent(payload);
                break;
            }
            case "Job Hook": {
                this.handleBuildJobEvent(payload);
                break;
            }
        }
        return Response.ok().build();
    }

    private void handlePushEvent(@Language(value="JSON") String payload) throws StorageException, BadRequestException {
        GitLabPushEvent pushEvent = GitLabWebHookService.deserializeEvent(payload, GitLabPushEvent.class);
        this.scheduleAffectedTriggers(pushEvent.repository.gitHttpUrl, pushEvent.repository.gitSshUrl);
    }

    private void scheduleAffectedTriggers(String gitHttpUrl, String gitSshUrl) throws StorageException {
        RepositoryUpdateUtils.extractAndScheduleAffectedTriggers((String)gitHttpUrl, (IndexLayer)this.getIndexLayer(), null);
        if (!StringUtils.isEmpty((String)gitSshUrl)) {
            RepositoryUpdateUtils.extractAndScheduleAffectedTriggers((String)GitUtils.rewriteGitAtUrl((String)gitSshUrl), (IndexLayer)this.getIndexLayer(), null);
        }
    }

    private void handleMergeRequestEvent(@Language(value="JSON") String payload) throws StorageException, BadRequestException {
        GitLabMergeRequestEvent mergeRequestEvent = GitLabWebHookService.deserializeEvent(payload, GitLabMergeRequestEvent.class);
        if (!mergeRequestEvent.project.pathWithNamespace.equals(mergeRequestEvent.objectAttributes.target.pathWithNamespace)) {
            this.scheduleAffectedTriggers(mergeRequestEvent.project.gitHttpUrl, mergeRequestEvent.project.sshUrlToRepo);
        }
        this.scheduleNecessaryMergeRequestUpdateTriggers(mergeRequestEvent);
    }

    private void scheduleNecessaryMergeRequestUpdateTriggers(GitLabMergeRequestEvent mergeRequestEvent) throws StorageException {
        this.scheduleMergeRequestUpdateTriggers(mergeRequestEvent.project.gitHttpUrl, mergeRequestEvent.project.pathWithNamespace, mergeRequestEvent.objectAttributes.iid, String.valueOf(mergeRequestEvent.project.id), GitLabMergeRequestUpdateTrigger.class, null);
        if (!StringUtils.isEmpty((String)mergeRequestEvent.project.sshUrlToRepo)) {
            this.scheduleMergeRequestUpdateTriggers(GitUtils.rewriteGitAtUrl((String)mergeRequestEvent.project.sshUrlToRepo), mergeRequestEvent.project.pathWithNamespace, mergeRequestEvent.objectAttributes.iid, String.valueOf(mergeRequestEvent.project.id), GitLabMergeRequestUpdateTrigger.class, null);
        }
    }

    private void handleBuildJobEvent(@Language(value="JSON") String payload) throws StorageException, BadRequestException {
        GitLabBuildJobEvent buildJobEvent = GitLabWebHookService.deserializeEvent(payload, GitLabBuildJobEvent.class);
        this.scheduleMergeRequestUpdateTriggers(buildJobEvent.repository.gitHttpUrl, buildJobEvent.projectName, buildJobEvent.sha, String.valueOf(buildJobEvent.projectId), GitLabMergeRequestUpdateTrigger.class);
    }

    private static <T> T deserializeEvent(@Language(value="JSON") String content, Class<T> expectedClass) throws BadRequestException {
        try {
            return (T)JsonUtils.deserializeFromJsonWithNullCheck((String)content, expectedClass);
        }
        catch (ConQATException e) {
            throw new BadRequestException("Invalid payload: " + e.getMessage(), (Throwable)e);
        }
    }

    private static class GitLabPushEvent {
        @JsonProperty(value="project")
        private GitLabProject project;
        @JsonProperty(value="repository")
        private GitLabRepository repository;

        private GitLabPushEvent() {
        }
    }

    private static class GitLabRepository {
        @JsonProperty(value="git_http_url")
        private String gitHttpUrl;
        @JsonProperty(value="git_ssh_url")
        private @Nullable String gitSshUrl;

        private GitLabRepository() {
        }
    }

    private static class GitLabMergeRequestEvent {
        @JsonProperty(value="project")
        private GitLabProject project;
        @JsonProperty(value="object_attributes")
        private GitLabObjectAttributes objectAttributes;

        private GitLabMergeRequestEvent() {
        }
    }

    private static class GitLabProject {
        @JsonProperty(value="id")
        private int id;
        @JsonProperty(value="path_with_namespace")
        private String pathWithNamespace;
        @JsonProperty(value="git_http_url")
        private String gitHttpUrl;
        @JsonProperty(value="git_ssh_url")
        private @Nullable String sshUrlToRepo;

        private GitLabProject() {
        }
    }

    private static class GitLabObjectAttributes {
        @JsonProperty(value="iid")
        private long iid;
        @JsonProperty(value="target")
        private GitLabProject target;

        private GitLabObjectAttributes() {
        }
    }

    private static class GitLabBuildJobEvent {
        @JsonProperty(value="project_id")
        private int projectId;
        @JsonProperty(value="project_name")
        private String projectName;
        @JsonProperty(value="sha")
        private String sha;
        @JsonProperty(value="repository")
        private GitLabRepository repository;

        private GitLabBuildJobEvent() {
        }
    }
}

