/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.logging;

import com.teamscale.core.rest.EHttpMethod;
import com.teamscale.core.user.User;
import com.teamscale.service.framework.IStaticServiceContext;
import com.teamscale.service.framework.impl.authentication.AuthenticationFilter;
import com.teamscale.service.framework.impl.factory.RequestInfoFactory;
import com.teamscale.service.framework.impl.factory.ServiceLoggerFactory;
import com.teamscale.service.framework.impl.logging.RecordingLoggerWrapper;
import com.teamscale.service.framework.logging.IRequestInfo;
import com.teamscale.service.framework.logging.ServiceLoggingUtils;
import jakarta.annotation.Priority;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.util.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.lib.commons.enums.EnumUtils;

@Provider
@PreMatching
@Priority(value=1)
public class ServiceLoggingRequestFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker REST_API_REQUEST_START_MARKER = MarkerManager.getMarker((String)"RequestStart");
    static final Logger REST_API_REQUEST_LOGGER = LogManager.getLogger((String)"teamscale-rest-api-requests");
    static final String THREAD_CONTEXT_REQUEST_UUID_FIELD = "requestUUID";
    static final String THREAD_CONTEXT_IP_ADDRESS_FIELD = "ip";
    @Context
    private IStaticServiceContext staticServiceContext;
    @Context
    private Providers providers;
    @Context
    private HttpServletRequest servletRequest;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        this.staticServiceContext.getServiceStatisticsRecorder().incServiceCalls();
        RequestInfo requestInfo = new RequestInfo(UUID.randomUUID().toString(), (EHttpMethod)EnumUtils.valueOf(EHttpMethod.class, (String)requestContext.getMethod()), requestContext.getUriInfo().getRequestUri(), this.determineLoggedUserName(requestContext), this.getLoggedIpAddress(), requestContext.getHeaderString("User-Agent"), System.nanoTime());
        RequestInfoFactory.attachTo(requestContext, requestInfo);
        ThreadContext.put((String)THREAD_CONTEXT_REQUEST_UUID_FIELD, (String)requestInfo.requestId());
        ThreadContext.put((String)"username", (String)requestInfo.username());
        ThreadContext.put((String)THREAD_CONTEXT_IP_ADDRESS_FIELD, (String)requestInfo.ipAddress());
        Supplier[] supplierArray = new Supplier[6];
        supplierArray[0] = requestInfo::httpMethod;
        supplierArray[1] = requestInfo::requestUri;
        supplierArray[2] = requestInfo::requestId;
        supplierArray[3] = requestInfo::username;
        supplierArray[4] = requestInfo::ipAddress;
        supplierArray[5] = requestInfo::userAgent;
        REST_API_REQUEST_LOGGER.info(REST_API_REQUEST_START_MARKER, "Request=\"{} {}\", Request-ID=\"{}\", User=\"{}\", IP=\"{}\", User-Agent=\"{}\"", supplierArray);
        RecordingLoggerWrapper logger = new RecordingLoggerWrapper();
        ServiceLoggerFactory.attachTo(requestContext, logger);
    }

    private @Nullable String getUsername(ContainerRequestContext requestContext) {
        try {
            User user = AuthenticationFilter.getOrAuthenticateUser(requestContext, this.staticServiceContext, this.providers);
            if (user != null) {
                return user.getUsername();
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("Unexpected error occurred while authenticating the user", (Throwable)e);
        }
        return null;
    }

    private @NonNull String getLoggedIpAddress() {
        if (this.servletRequest != null && this.staticServiceContext.getServerConfiguration().isServiceLogIncludeIp()) {
            return this.servletRequest.getRemoteAddr();
        }
        return "<unknown>";
    }

    private @NonNull String determineLoggedUserName(ContainerRequestContext requestContext) {
        boolean includeUsername = this.staticServiceContext.getServerConfiguration().isServiceLogIncludeUsers();
        @Nullable String username = this.getUsername(requestContext);
        MetaIndex metaIndex = this.staticServiceContext.getMetaIndex();
        return ServiceLoggingUtils.determineLoggedUserName((boolean)includeUsername, (String)username, (MetaIndex)metaIndex);
    }

    private record RequestInfo(String requestId, EHttpMethod httpMethod, URI requestUri, String username, String ipAddress, String userAgent, long startTime) implements IRequestInfo
    {
        public long timeSinceRequestStartInNanoseconds() {
            return System.nanoTime() - this.startTime();
        }
    }
}

