/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Set;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.symbols.Symbols;
import org.sonar.plugins.php.api.symbols.SymbolTable;
import org.sonar.plugins.php.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S100")
public class FunctionNameCheck
extends PHPVisitorCheck {
    public static final String KEY = "S100";
    private static final String MESSAGE = "Rename function \"%s\" to match the regular expression %s.";
    private static final Set<String> MAGIC_METHODS = Set.of("__construct", "__destruct", "__call", "__callStatic", "__get", "__set", "__isset", "__unset", "__sleep", "__wakeup", "__toString", "__invoke", "__set_state", "__clone", "__debugInfo");
    public static final String DEFAULT = "^[a-z][a-zA-Z0-9]*$";
    public static final String DEFAULT_DRUPAL = "^[a-z][a-z0-9_]*$";
    private static final Pattern patternDrupal = Pattern.compile("^[a-z][a-z0-9_]*$");
    private Pattern pattern = null;
    @RuleProperty(key="format", defaultValue="^[a-z][a-zA-Z0-9]*$")
    public String format = "^[a-z][a-zA-Z0-9]*$";

    @Override
    public void init() {
        this.pattern = Pattern.compile(this.format);
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        if (Symbols.get(tree).isOverriding().isFalse()) {
            this.check(tree.name());
        }
        super.visitMethodDeclaration(tree);
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclarationTree tree) {
        this.check(tree.name());
        super.visitFunctionDeclaration(tree);
    }

    private void check(NameIdentifierTree name) {
        String functionName = name.text();
        if (!this.computePattern().matcher(functionName).matches() && !MAGIC_METHODS.contains(functionName)) {
            this.context().newIssue(this, name, String.format(MESSAGE, functionName, this.computeFormat()));
        }
    }

    private Pattern computePattern() {
        if (this.isDrupal()) {
            return patternDrupal;
        }
        return this.pattern;
    }

    private String computeFormat() {
        if (this.isDrupal()) {
            return DEFAULT_DRUPAL;
        }
        return this.format;
    }

    private boolean isDrupal() {
        return this.context().getFramework() == SymbolTable.Framework.DRUPAL && this.format.equals(DEFAULT);
    }
}

