/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.php.api.PHPKeyword;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.tree.symbols.Scope;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.ClassPropertyDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassTree;
import org.sonar.plugins.php.api.tree.declaration.FunctionTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.declaration.VariableDeclarationTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1117")
public class LocalVariableShadowsClassFieldCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1117";
    private static final String MESSAGE = "Rename \"%s\" which has the same name as the field declared at line %s.";
    private static final String SECONDARY_MESSAGE = "Shadowed field.";
    private Deque<ClassState> classStates = new ArrayDeque<ClassState>();
    private Deque<FunctionTree> functions = new ArrayDeque<FunctionTree>();

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.classStates.clear();
        this.functions.clear();
        super.visitCompilationUnit(tree);
    }

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        ClassState classState = new ClassState();
        classState.setClassName(tree.name().text());
        this.classStates.push(classState);
        this.collectClassData(tree);
        super.visitClassDeclaration(tree);
        this.classStates.pop();
    }

    @Override
    public void visitAnonymousClass(AnonymousClassTree tree) {
        this.scan(tree.arguments());
        this.classStates.push(new ClassState());
        this.collectClassData(tree);
        NamespaceNameTree superClass = tree.superClass();
        if (superClass != null) {
            this.scan(superClass);
        }
        this.scan(tree.superInterfaces());
        this.scan(tree.members());
        this.classStates.pop();
    }

    private void collectClassData(ClassTree tree) {
        for (ClassMemberTree classMemberTree : tree.members()) {
            if (!classMemberTree.is(Tree.Kind.CLASS_PROPERTY_DECLARATION)) continue;
            for (VariableDeclarationTree declaration : ((ClassPropertyDeclarationTree)classMemberTree).declarations()) {
                this.classStates.peek().declareField(declaration.identifier().token());
            }
        }
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        if (!this.isExcluded(tree)) {
            this.classStates.peek().newFunctionScope();
            this.functions.push(tree);
            super.visitMethodDeclaration(tree);
            this.functions.pop();
            this.classStates.peek().leaveFunctionScope();
        }
    }

    @Override
    public void visitFunctionExpression(FunctionExpressionTree tree) {
        if (!this.classStates.isEmpty()) {
            this.classStates.peek().newFunctionScope();
            this.functions.push(tree);
            super.visitFunctionExpression(tree);
            this.functions.pop();
            this.classStates.peek().leaveFunctionScope();
        }
    }

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (!this.classStates.isEmpty()) {
            this.checkLocalVariable(tree.variable());
        }
        super.visitAssignmentExpression(tree);
    }

    private void checkLocalVariable(ExpressionTree assignedExpression) {
        String varName = assignedExpression.toString();
        if (this.isLocalVar(varName) && this.classStates.peek().hasFieldNamed(varName) && !this.classStates.peek().hasAlreadyBeenChecked(varName)) {
            this.reportIssue(assignedExpression, varName);
        }
    }

    private boolean isLocalVar(String varName) {
        if (this.functions.isEmpty()) {
            return false;
        }
        Scope scope = this.context().symbolTable().getScopeFor(this.functions.peek());
        return scope.getSymbol(varName, Symbol.Kind.VARIABLE) != null;
    }

    private boolean isExcluded(MethodDeclarationTree methodDec) {
        String methodName = methodDec.name().text();
        return CheckUtils.hasModifier(methodDec.modifiers(), PHPKeyword.STATIC.getValue()) || this.isConstructor(methodName) || LocalVariableShadowsClassFieldCheck.isSetter(methodName);
    }

    private static boolean isSetter(String methodName) {
        return methodName.startsWith("set");
    }

    private boolean isConstructor(String methodName) {
        return this.classStates.peek().className != null && this.classStates.peek().className.equalsIgnoreCase(methodName) || "__construct".equalsIgnoreCase(methodName);
    }

    private void reportIssue(Tree tree, String varName) {
        SyntaxToken field = this.classStates.peek().getFieldNamed(varName);
        String message = String.format(MESSAGE, varName, field.line());
        this.context().newIssue(this, tree, message).secondary(field, SECONDARY_MESSAGE);
        this.classStates.peek().setAsCheckedVariable(varName);
    }

    private static class ClassState {
        private Map<String, SyntaxToken> classFields = new HashMap<String, SyntaxToken>();
        private Deque<Set<String>> checkedVariables = new ArrayDeque<Set<String>>();
        private String className = null;

        private ClassState() {
        }

        public void setClassName(@Nullable String name) {
            this.className = name;
        }

        public void declareField(SyntaxToken fieldToken) {
            this.classFields.put(fieldToken.text(), fieldToken);
        }

        public boolean hasFieldNamed(String paramName) {
            return this.classFields.containsKey(paramName);
        }

        public SyntaxToken getFieldNamed(String name) {
            return this.classFields.get(name);
        }

        public void setAsCheckedVariable(String varName) {
            this.checkedVariables.peek().add(varName);
        }

        public boolean hasAlreadyBeenChecked(String varName) {
            return this.checkedVariables.peek().contains(varName);
        }

        public void newFunctionScope() {
            this.checkedVariables.push(new HashSet());
        }

        public void leaveFunctionScope() {
            this.checkedVariables.pop();
        }
    }
}

