/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S139")
public class TrailingCommentCheck
extends PHPVisitorCheck {
    public static final String KEY = "S139";
    private static final String MESSAGE = "Move this trailing comment on the previous empty line.";
    public static final String DEFAULT_LEGAL_COMMENT_PATTERN = "^(//|#)\\s*+[^\\s]++$";
    @RuleProperty(key="legalTrailingCommentPattern", defaultValue="^(//|#)\\s*+[^\\s]++$")
    String legalCommentPattern = "^(//|#)\\s*+[^\\s]++$";
    private Pattern pattern;
    private int previousTokenLine;

    @Override
    public void init() {
        super.init();
        this.pattern = Pattern.compile(this.legalCommentPattern);
    }

    @Override
    public void visitScript(ScriptTree tree) {
        this.previousTokenLine = -1;
        super.visitScript(tree);
    }

    @Override
    public void visitToken(SyntaxToken token) {
        for (SyntaxTrivia trivia : token.trivias()) {
            String comment;
            if (trivia.line() != this.previousTokenLine || !(comment = trivia.text()).startsWith("//") && !comment.startsWith("#") || this.pattern.matcher(comment).matches()) continue;
            this.context().newIssue(this, trivia, MESSAGE);
        }
        this.previousTokenLine = token.line();
    }
}

