/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.api.visitors;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.Tree;

public abstract class PHPTreeSubscriber {
    private Collection<Tree.Kind> nodesToVisit;

    public abstract List<Tree.Kind> nodesToVisit();

    public void visitNode(Tree tree) {
    }

    public void leaveNode(Tree tree) {
    }

    public void scanTree(Tree tree) {
        this.nodesToVisit = this.nodesToVisit();
        this.visit(tree);
    }

    private void visit(Tree tree) {
        boolean isSubscribed = this.isSubscribed(tree);
        if (isSubscribed) {
            this.visitNode(tree);
        }
        this.visitChildren(tree);
        if (isSubscribed) {
            this.leaveNode(tree);
        }
    }

    private boolean isSubscribed(Tree tree) {
        return this.nodesToVisit.contains(tree.getKind());
    }

    private void visitChildren(Tree tree) {
        PHPTree javaTree = (PHPTree)tree;
        if (!javaTree.isLeaf()) {
            Iterator<Tree> iter = javaTree.childrenIterator();
            while (iter.hasNext()) {
                Tree next = iter.next();
                if (next == null) continue;
                this.visit(next);
            }
        }
    }
}

