/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.util;

public final class Casts {
    public static final short MASK_UINT8 = 255;
    public static final int MASK_UINT16 = 65535;
    public static final long MASK_UINT32 = 0xFFFFFFFFL;

    private Casts() {
    }

    public static boolean logical(double value) {
        return value != 0.0;
    }

    public static byte int8(boolean value) {
        return (byte)(value ? 1 : 0);
    }

    public static byte int8(long value) {
        return (byte)value;
    }

    public static short int16(long value) {
        return (short)value;
    }

    public static int int32(long value) {
        return (int)value;
    }

    public static byte sint8(long value) {
        if (value > 127L) {
            throw new IllegalArgumentException("Value is above signed int8 range");
        }
        if (value < -128L) {
            throw new IllegalArgumentException("Value is below signed int8 range");
        }
        return (byte)value;
    }

    public static short sint16(long value) {
        if (value > 32767L) {
            throw new IllegalArgumentException("Value is above signed int16 range");
        }
        if (value < -32768L) {
            throw new IllegalArgumentException("Value is below signed int16 range");
        }
        return (short)value;
    }

    public static int sint32(long value) {
        if (value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Value is above signed int32 range");
        }
        if (value < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Value is below signed int32 range");
        }
        return (int)value;
    }

    public static float single(double value) {
        return (float)value;
    }

    public static short uint8(byte value) {
        return (short)(value & 0xFF);
    }

    public static int uint16(short value) {
        return value & 0xFFFF;
    }

    public static long uint32(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    public static boolean isInteger(double value) {
        return Math.rint(value) == value && !Double.isNaN(value) && !Double.isInfinite(value);
    }

    public static boolean fitsByte(long value) {
        return value == (long)((byte)value) || value >>> 8 == 0L;
    }

    public static boolean fitsShort(long value) {
        return value == (long)((short)value) || value >>> 16 == 0L;
    }

    public static boolean fitsInt(long value) {
        return value == (long)((int)value) || value >>> 32 == 0L;
    }

    public static int checkedDivide(int numerator, int denominator) {
        int remainder = numerator % denominator;
        if (remainder != 0) {
            String format = String.format("%d is not a multiple of %d", numerator, denominator);
            throw new IllegalArgumentException(format);
        }
        return numerator / denominator;
    }
}

