/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.rest.client;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.BearerScheme;
import com.teamscale.core.rest.client.TeamscaleHttpRequestRetryHandler;
import com.teamscale.core.rest.client.cookie.CookiesHandler;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.config.SocketConfig;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

@Deprecated
public final class HttpClientUtils {
    private static final long DEFAULT_TIMEOUT = 60000L;
    private static SSLContext sslContext = null;
    private static HostnameVerifier hostnameVerifier = null;
    private static final String SITEMINDER_SESSION_COOKIE_NAME = "SMSESSION";

    public static HttpClientContext getContext(String url, @Nullable String username, String passwordOrBearerToken, List<String> cookies) throws URISyntaxException {
        HttpClientContext context = HttpClientContext.create();
        URI uri = new URI(url);
        if (!StringUtils.isEmpty((String)username) && !StringUtils.isEmpty((String)passwordOrBearerToken)) {
            HttpClientUtils.addBasicAuthentication(context, uri, new UsernamePasswordCredentials(username, passwordOrBearerToken));
        }
        if (StringUtils.isEmpty((String)username) && !StringUtils.isEmpty((String)passwordOrBearerToken)) {
            HttpClientUtils.addBearerAuthentication(context, uri, passwordOrBearerToken);
        }
        if (!CollectionUtils.isNullOrEmpty(cookies)) {
            HttpClientUtils.addCookies(context, uri, cookies);
        }
        return context;
    }

    private static void addBasicAuthentication(HttpClientContext context, URI uri, UsernamePasswordCredentials usernamePasswordCredentials) {
        HttpHost targetHost = URIUtils.extractHost((URI)uri);
        CredentialsProvider credentialsProvider = context.getCredentialsProvider();
        if (credentialsProvider == null) {
            credentialsProvider = new BasicCredentialsProvider();
            context.setCredentialsProvider(credentialsProvider);
        }
        AuthScope authScope = new AuthScope(targetHost.getHostName(), targetHost.getPort());
        credentialsProvider.setCredentials(authScope, (Credentials)usernamePasswordCredentials);
        AuthCache authCache = context.getAuthCache();
        if (authCache == null) {
            authCache = new BasicAuthCache();
            context.setAuthCache(authCache);
        }
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(targetHost, (AuthScheme)basicAuth);
    }

    private static void addCookies(HttpClientContext context, URI uri, List<String> cookies) {
        context.setCookieStore((CookieStore)CookiesHandler.getCookieStore(uri, cookies));
    }

    private static void addBearerAuthentication(HttpClientContext context, URI uri, String bearerToken) {
        HttpHost targetHost = URIUtils.extractHost((URI)uri);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(targetHost.getHostName(), targetHost.getPort()), (Credentials)new UsernamePasswordCredentials("", bearerToken));
        BasicAuthCache authCache = new BasicAuthCache();
        BearerScheme bearerAuth = new BearerScheme();
        authCache.put(targetHost, (AuthScheme)bearerAuth);
        context.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        context.setAuthCache((AuthCache)authCache);
    }

    public static <T extends Exception> void checkStatusCode(StatusLine statusLine, String serverType, URI uri, Function<String, T> exceptionFactory) throws T {
        if (statusLine.getStatusCode() == 200 || statusLine.getStatusCode() == 204) {
            return;
        }
        Object message = switch (statusLine.getStatusCode()) {
            case 404 -> serverType + " server returned error code 404/not found. Is the server URL correct? Given: " + String.valueOf(uri);
            case 403 -> "It is forbidden to gather info from the " + serverType + " server. Does the user have the necessary rights to access the server?";
            case 401 -> "Authentication failed. Username/password incorrect?";
            default -> "Unable to gather the information from the " + serverType + " server at " + String.valueOf(uri) + ". Error code " + statusLine.getStatusCode();
        };
        throw (Exception)exceptionFactory.apply((String)message + " (" + statusLine.getReasonPhrase() + ")");
    }

    public static CloseableHttpResponse executeGet(CloseableHttpClient httpclient, URI uri, HttpClientContext context) throws IOException {
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)new HttpGet(uri), (HttpContext)context);
        return HttpClientUtils.retryGetForSiteMinderIfNecessary(response, context, httpclient, uri);
    }

    private static CloseableHttpResponse retryGetForSiteMinderIfNecessary(CloseableHttpResponse response, HttpClientContext context, CloseableHttpClient httpclient, URI uri) throws IOException {
        List cookiesFromResponse;
        if (response.getStatusLine().getStatusCode() == 403 && (cookiesFromResponse = context.getCookieStore().getCookies()).stream().anyMatch(cookie -> cookie.getName().equals(SITEMINDER_SESSION_COOKIE_NAME))) {
            return HttpClientUtils.executeGet(httpclient, uri, context);
        }
        return response;
    }

    private static CloseableHttpResponse executeEntityRequest(HttpEntityEnclosingRequestBase request, CloseableHttpClient httpclient, HttpContext context, String payload, ContentType contentType) throws IOException {
        if (contentType != null) {
            request.setEntity((HttpEntity)new StringEntity(payload, contentType));
        } else {
            request.setEntity((HttpEntity)new StringEntity(payload));
        }
        return httpclient.execute((HttpUriRequest)request, context);
    }

    public static CloseableHttpResponse executePost(CloseableHttpClient httpclient, URI uri, HttpContext context, String payload) throws IOException {
        HttpPost request = new HttpPost(uri);
        return HttpClientUtils.executeEntityRequest((HttpEntityEnclosingRequestBase)request, httpclient, context, payload, null);
    }

    public static CloseableHttpResponse executePut(CloseableHttpClient httpclient, URI uri, HttpContext context, String payload, ContentType contentType) throws IOException {
        HttpPut request = new HttpPut(uri);
        return HttpClientUtils.executeEntityRequest((HttpEntityEnclosingRequestBase)request, httpclient, context, payload, contentType);
    }

    private static HttpClientBuilder createHttpClientBuilder() {
        return HttpClientUtils.createHttpClientBuilder(60000L);
    }

    public static HttpClientBuilder createHttpClientBuilder(long timeoutMilliSeconds) {
        int timeout = (int)timeoutMilliSeconds;
        RequestConfig.Builder requestBuilder = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout);
        HttpClientBuilder builder = HttpClientBuilder.create().useSystemProperties();
        if (sslContext != null) {
            builder.setSSLContext(sslContext);
        }
        if (hostnameVerifier != null) {
            builder.setSSLHostnameVerifier(hostnameVerifier);
        }
        builder.setRetryHandler((HttpRequestRetryHandler)new TeamscaleHttpRequestRetryHandler());
        return builder.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(timeout).build()).setDefaultRequestConfig(requestBuilder.build());
    }

    public static CloseableHttpClient createHttpClient() {
        return HttpClientUtils.createHttpClientBuilder().build();
    }

    public static CloseableHttpClient createHttpClient(long timeoutMilliSeconds) {
        return HttpClientUtils.createHttpClientBuilder(timeoutMilliSeconds).build();
    }

    public static void overwriteSslContextAndHostnameVerifier(SSLContext sslContext, HostnameVerifier hostnameVerifier) {
        HttpClientUtils.sslContext = sslContext;
        HttpClientUtils.hostnameVerifier = hostnameVerifier;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T executeAndParseRequest(HttpRequestBase request, int expectedStatusCode, Class<T> expectedType, ConsumerWithException<HttpResponse, ServiceCallException> responseProcessor, String responseContentType) throws ServiceCallException {
        request.setHeader("Accept", responseContentType);
        try (CloseableHttpClient client = HttpClientUtils.createHttpClient();){
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != expectedStatusCode) {
                String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new ServiceCallException(request.getURI(), response.getStatusLine().getReasonPhrase(), statusCode, responseString);
            }
            if (responseProcessor != null) {
                responseProcessor.accept((Object)response);
            }
            Object object = JsonUtils.deserializeFromJson((String)EntityUtils.toString((HttpEntity)response.getEntity()), expectedType);
            return (T)object;
        }
        catch (IOException e) {
            throw new ServiceCallException("Http request " + String.valueOf(request.getRequestLine()) + " failed: " + e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            throw new ServiceCallException("Parsing HTTP response from " + String.valueOf(request.getRequestLine()) + " failed: " + e.getMessage(), (Throwable)e);
        }
        catch (ConQATException e) {
            throw new ServiceCallException("JSON deserialization of response from " + String.valueOf(request.getRequestLine()) + " failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void checkHttpConnection(URL url) throws IOException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.connect();
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private HttpClientUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

