/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-legacy-string-concatenation", languages={ELanguage.ABAP})
public class LegacyStringConcatenationCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        if (TokenStreamUtils.startsWith((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.CONCATENATE}) || this.containsSingleLineConcatenation((List<IToken>)tokens)) {
            this.buildFinding("String concatenation does not use string template", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }

    private boolean containsSingleLineConcatenation(List<IToken> tokens) {
        for (int i = 1; i < tokens.size() - 1; ++i) {
            IToken token = tokens.get(i);
            if (token.getType() != ETokenType.CONCATENATION || !this.areAllOnSameLine(tokens.subList(i - 1, i + 2))) continue;
            return true;
        }
        return false;
    }

    private boolean areAllOnSameLine(List<IToken> tokens) {
        return tokens.stream().map(IToken::getLineNumber).distinct().count() == 1L;
    }
}

